/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.AutoSieveBaseBlock;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.menu.AutoSieveMenu;
import net.blay09.mods.excompressum.menu.ModMenus;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.autosieveskin.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.autosieveskin.WhitelistEntry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoSieveBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<BlockPos>,
BalmContainerProvider {
    private static final int UPDATE_INTERVAL = 20;
    private static final int PARTICLE_TICKS = 30;
    private final DefaultContainer backingContainer = new DefaultContainer(22){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (AbstractAutoSieveBlockEntity.this.inputSlots.containsOuterSlot(slot)) {
                return AbstractAutoSieveBlockEntity.this.isSiftableWithMesh(itemStack, AbstractAutoSieveBlockEntity.this.getSieveMesh());
            }
            if (AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot)) {
                return AbstractAutoSieveBlockEntity.this.isMesh(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            super.slotChanged(slot);
            if (AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot)) {
                AbstractAutoSieveBlockEntity.this.isDirty = true;
            }
        }
    };
    private final ContainerData containerData = new ContainerData(){

        public int get(int id) {
            if (id == 0) {
                return (int)(100.0f * AbstractAutoSieveBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AbstractAutoSieveBlockEntity.this.getEnergyStored();
            }
            if (id == 2) {
                return AbstractAutoSieveBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            return 0;
        }

        public void set(int id, int value) {
            if (id == 0) {
                AbstractAutoSieveBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AbstractAutoSieveBlockEntity.this.setEnergyStored(value);
            } else if (id == 2) {
                AbstractAutoSieveBlockEntity.this.setDisabledByRedstone(value == 1);
            }
        }

        public int getCount() {
            return 3;
        }
    };
    private final SubContainer inputSlots = new SubContainer((Container)this.backingContainer, 0, 1);
    private final SubContainer outputSlots = new SubContainer((Container)this.backingContainer, 1, 21);
    private final SubContainer meshSlots = new SubContainer((Container)this.backingContainer, 21, 22);
    private final List<ItemStack> overflowBuffer = new ArrayList<ItemStack>();
    private final DelegateContainer container = new DelegateContainer((Container)this.backingContainer){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            return super.canPlaceItem(slot, itemStack) && (AbstractAutoSieveBlockEntity.this.inputSlots.containsOuterSlot(slot) || AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot));
        }

        public int[] getSlotsForFace(Direction direction) {
            if (direction == Direction.DOWN) {
                return AbstractAutoSieveBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            if (direction == Direction.UP) {
                return AbstractAutoSieveBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
            }
            return AbstractAutoSieveBlockEntity.this.meshSlots.getOuterSlotsForFace(direction);
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
            return AbstractAutoSieveBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }

        public boolean canExtractItem(int slot) {
            return AbstractAutoSieveBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private ItemStack currentStack = ItemStack.EMPTY;
    private ResolvableProfile skinProfile;
    private int ticksSinceSync;
    protected boolean isDirty;
    private float progress;
    private float foodBoost;
    private int foodBoostTicks;
    public float armAngle;
    private int particleTicks;
    private int particleCount;
    private boolean isDisabledByRedstone;

    public AbstractAutoSieveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AbstractAutoSieveBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractAutoSieveBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (this.particleTicks > 0) {
            BlockState processingState;
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (!(this.currentStack.isEmpty() || this.isUgly() || (processingState = StupidUtils.getStateFromItemStack(this.currentStack)).isAir())) {
                ((CommonProxy)ExCompressum.proxy.get()).spawnAutoSieveParticles(this.level, this.worldPosition, this.getBlockState(), processingState, this.particleCount);
            }
        }
    }

    public void serverTick() {
        if (this.foodBoostTicks > 0) {
            --this.foodBoostTicks;
            if (this.foodBoostTicks <= 0) {
                this.foodBoost = 0.0f;
            }
        }
        ++this.ticksSinceSync;
        if (this.ticksSinceSync > 20) {
            if (this.isDirty) {
                this.setChanged();
                this.sync();
                this.isDirty = false;
            }
            this.ticksSinceSync = 0;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack.isEmpty()) {
                ItemStack inputStack = this.inputSlots.getItem(0);
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (!inputStack.isEmpty() && sieveMesh != null && this.isSiftableWithMesh(inputStack, sieveMesh)) {
                    boolean foundSpace = false;
                    for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
                        if (!this.outputSlots.getItem(i).isEmpty()) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = inputStack.split(1);
                    if (inputStack.isEmpty()) {
                        this.inputSlots.setItem(0, ItemStack.EMPTY);
                    }
                    this.drainEnergy(effectiveEnergy, false);
                    this.sync();
                    this.progress = 0.0f;
                }
            } else {
                this.drainEnergy(effectiveEnergy, false);
                this.progress += this.getEffectiveSpeed();
                this.particleTicks = 30;
                this.particleCount = (int)this.getSpeedMultiplier();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (!this.level.isClientSide) {
                        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                        if (sieveMesh != null) {
                            ItemStack meshStack;
                            Collection<ItemStack> rewards = this.rollSieveRewards(this.level, this.currentStack, sieveMesh, this.getEffectiveLuck(), this.level.random);
                            for (ItemStack itemStack : rewards) {
                                if (this.addItemToOutput(itemStack)) continue;
                                this.overflowBuffer.add(itemStack);
                            }
                            if (ExNihilo.getInstance().doMeshesHaveDurability() && !(meshStack = this.meshSlots.getItem(0)).isEmpty()) {
                                meshStack.hurtAndBreak(1, (ServerLevel)this.level, null, it -> {
                                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.5f, 2.5f);
                                    meshStack.shrink(1);
                                    this.meshSlots.setItem(0, ItemStack.EMPTY);
                                });
                            }
                        } else if (!this.addItemToOutput(this.currentStack)) {
                            this.overflowBuffer.add(this.currentStack);
                        }
                    }
                    this.progress = 0.0f;
                    this.currentStack = ItemStack.EMPTY;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.get(0))) {
            this.overflowBuffer.remove(0);
        }
    }

    protected abstract int drainEnergy(int var1, boolean var2);

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
            ItemStack slotStack = this.outputSlots.getItem(i);
            if (slotStack.isEmpty()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.getCount() + itemStack.getCount() > slotStack.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            slotStack.grow(itemStack.getCount());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setItem(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoSieveEnergy;
    }

    public float getEffectiveSpeed() {
        return (float)(ExCompressumConfig.getActive().automation.autoSieveSpeed * (double)this.getSpeedMultiplier());
    }

    public float getEffectiveLuck() {
        ItemStack meshStack = this.meshSlots.getItem(0);
        if (!meshStack.isEmpty()) {
            return ExNihilo.getInstance().getMeshFortune(meshStack);
        }
        return 0.0f;
    }

    public boolean isSiftableWithMesh(ItemStack itemStack, @Nullable SieveMeshRegistryEntry sieveMesh) {
        return ExNihilo.isSiftableWithMesh(this.level, this.getBlockState(), itemStack, sieveMesh);
    }

    private boolean isMesh(ItemStack itemStack) {
        return SieveMeshRegistry.getEntry(itemStack) != null;
    }

    public Collection<ItemStack> rollSieveRewards(Level level, ItemStack itemStack, SieveMeshRegistryEntry sieveMesh, float luck, RandomSource rand) {
        return ExNihilo.rollSieveRewards(level, this.getBlockState(), itemStack, sieveMesh, luck, rand);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.currentStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("CurrentStack"));
        this.progress = tag.getFloat("Progress");
        ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("CustomSkin")).resultOrPartial($$0x -> ExCompressum.logger.error("Failed to load profile from auto sieve: {}", $$0x)).ifPresent(it -> this.setSkinProfile((ResolvableProfile)it));
        this.foodBoost = tag.getFloat("FoodBoost");
        this.foodBoostTicks = tag.getInt("FoodBoostTicks");
        this.particleTicks = tag.getInt("ParticleTicks");
        this.particleCount = tag.getInt("ParticleCount");
        this.backingContainer.deserialize(tag.getCompound("ItemHandler"), provider);
        this.isDisabledByRedstone = tag.getBoolean("IsDisabledByRedstone");
        this.overflowBuffer.clear();
        for (Tag overflowItem : tag.getList("OverflowBuffer", 10)) {
            this.overflowBuffer.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)overflowItem)));
        }
        if (tag.contains("MeshStack", 10)) {
            this.meshSlots.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("MeshStack")));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("CurrentStack", this.currentStack.saveOptional(provider));
        tag.putFloat("Progress", this.progress);
        if (this.skinProfile != null) {
            Tag customSkinTag = (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.skinProfile).getOrThrow();
            tag.put("CustomSkin", customSkinTag);
        }
        tag.putFloat("FoodBoost", this.foodBoost);
        tag.putInt("FoodBoostTicks", this.foodBoostTicks);
        tag.putInt("ParticleTicks", this.particleTicks);
        tag.putInt("ParticleCount", this.particleCount);
        tag.put("ItemHandler", (Tag)this.backingContainer.serialize(provider));
        tag.putBoolean("IsDisabledByRedstone", this.isDisabledByRedstone());
        ListTag overflowList = new ListTag();
        for (ItemStack itemStack : this.overflowBuffer) {
            overflowList.add((Object)itemStack.save(provider));
        }
        tag.put("OverflowBuffer", (Tag)overflowList);
    }

    public void writeUpdateTag(CompoundTag tag) {
        RegistryAccess provider = this.level.registryAccess();
        this.saveAdditional(tag, (HolderLookup.Provider)provider);
        ItemStack meshStack = this.meshSlots.getItem(0);
        tag.put("MeshStack", meshStack.saveOptional((HolderLookup.Provider)provider));
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    public abstract int getEnergyStored();

    public abstract void setEnergyStored(int var1);

    public abstract int getMaxEnergyStored();

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public void setSkinProfile(@Nullable ResolvableProfile skinProfile) {
        this.skinProfile = skinProfile;
        this.updateSkinProfile();
        this.isDirty = true;
        this.setChanged();
    }

    @Nullable
    public ResolvableProfile getSkinProfile() {
        return this.skinProfile;
    }

    private void updateSkinProfile() {
        if (this.skinProfile != null && !this.skinProfile.isResolved()) {
            this.skinProfile.resolve().thenAcceptAsync(result -> {
                this.skinProfile = result;
                this.setChanged();
            }, SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        } else {
            this.setChanged();
        }
    }

    public float getSpeedMultiplier() {
        float EFFICIENCY_BOOST = 0.25f;
        float boost = 1.0f;
        ItemStack meshStack = this.meshSlots.getItem(0);
        if (!meshStack.isEmpty()) {
            boost += 0.25f * (float)ExNihilo.getInstance().getMeshEfficiency(meshStack);
        }
        return boost * this.getFoodBoost();
    }

    public float getFoodBoost() {
        return 1.0f + this.foodBoost;
    }

    public void setFoodBoost(int foodBoostTicks, float foodBoost) {
        this.foodBoostTicks = foodBoostTicks;
        this.foodBoost = foodBoost;
        this.isDirty = true;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        ItemStack meshStack = this.meshSlots.getItem(0);
        if (!meshStack.isEmpty()) {
            return SieveMeshRegistry.getEntry(meshStack);
        }
        return null;
    }

    public ItemStack getMeshStack() {
        return this.meshSlots.getItem(0);
    }

    public boolean isCorrectSieveMesh() {
        ItemStack inputStack = this.inputSlots.getItem(0);
        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
        return inputStack.isEmpty() || sieveMesh == null || this.isSiftableWithMesh(inputStack, sieveMesh);
    }

    public boolean shouldAnimate() {
        return !this.currentStack.isEmpty() && this.getEnergyStored() >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    public boolean isUgly() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)ModBlockStateProperties.UGLY)) {
            return (Boolean)state.getValue((Property)ModBlockStateProperties.UGLY);
        }
        return false;
    }

    public boolean isWaterlogged() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)AutoSieveBaseBlock.WATERLOGGED)) {
            return (Boolean)state.getValue((Property)AutoSieveBaseBlock.WATERLOGGED);
        }
        return false;
    }

    public Direction getFacing() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)AutoSieveBaseBlock.FACING) ? (Direction)state.getValue((Property)AutoSieveBaseBlock.FACING) : Direction.NORTH;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceSync = 20;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.excompressum.auto_sieve");
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new AutoSieveMenu((MenuType<AutoSieveMenu>)((MenuType)ModMenus.autoSieve.get()), windowId, inventory, this);
    }

    public SieveAnimationType getAnimationType() {
        return SieveAnimationType.DEFAULT;
    }

    public void applyFoodBoost(FoodProperties food) {
        int foodBoostTicks = (int)food.saturation() * 640;
        if (foodBoostTicks <= 0) {
            foodBoostTicks = 640;
        }
        float foodBoost = Math.max(1.0f, (float)food.nutrition() * 0.75f);
        this.setFoodBoost(foodBoostTicks, foodBoost);
    }

    public Container getBackingContainer() {
        return this.backingContainer;
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        ResolvableProfile profile = (ResolvableProfile)input.get(DataComponents.PROFILE);
        if (profile == null) {
            WhitelistEntry randomSkin = AutoSieveSkinRegistry.getRandomSkin();
            if (randomSkin != null) {
                this.setSkinProfile(new ResolvableProfile(Optional.of(randomSkin.getName()), Optional.of(randomSkin.getUuid()), new PropertyMap()));
            }
        } else {
            this.setSkinProfile(profile);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (this.skinProfile != null) {
            builder.set(DataComponents.PROFILE, (Object)this.skinProfile);
        }
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }
}

