/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.excompressum.block.AutoCompressedHammerBlock;
import net.blay09.mods.excompressum.block.AutoCompressorBlock;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.AutoHeavySieveBlock;
import net.blay09.mods.excompressum.block.AutoSieveBlock;
import net.blay09.mods.excompressum.block.BaitBlock;
import net.blay09.mods.excompressum.block.BaitType;
import net.blay09.mods.excompressum.block.CompressedBlock;
import net.blay09.mods.excompressum.block.CompressedBlockType;
import net.blay09.mods.excompressum.block.HeavySieveBlock;
import net.blay09.mods.excompressum.block.HeavySieveType;
import net.blay09.mods.excompressum.block.RationingAutoCompressorBlock;
import net.blay09.mods.excompressum.block.WoodenCrucibleBlock;
import net.blay09.mods.excompressum.block.WoodenCrucibleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static Block[] compressedBlocks;
    public static Block[] heavySieves;
    public static Block[] woodenCrucibles;
    public static Block[] baits;
    public static Block autoHammer;
    public static Block autoCompressedHammer;
    public static Block autoHeavySieve;
    public static Block autoSieve;
    public static Block autoCompressor;
    public static Block rationingAutoCompressor;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(() -> {
            autoHammer = new AutoHammerBlock(ModBlocks.defaultProperties());
            return autoHammer;
        }, () -> ModBlocks.itemBlock(autoHammer), ModBlocks.id("auto_hammer"));
        blocks.register(() -> {
            autoSieve = new AutoSieveBlock(ModBlocks.defaultProperties());
            return autoSieve;
        }, () -> ModBlocks.itemBlock(autoSieve), ModBlocks.id("auto_sieve"));
        blocks.register(() -> {
            autoCompressedHammer = new AutoCompressedHammerBlock(ModBlocks.defaultProperties());
            return autoCompressedHammer;
        }, () -> ModBlocks.itemBlock(autoCompressedHammer), ModBlocks.id("auto_compressed_hammer"));
        blocks.register(() -> {
            autoHeavySieve = new AutoHeavySieveBlock(ModBlocks.defaultProperties());
            return autoHeavySieve;
        }, () -> ModBlocks.itemBlock(autoHeavySieve), ModBlocks.id("auto_heavy_sieve"));
        blocks.register(() -> {
            autoCompressor = new AutoCompressorBlock(ModBlocks.defaultProperties());
            return autoCompressor;
        }, () -> ModBlocks.itemBlock(autoCompressor), ModBlocks.id("auto_compressor"));
        blocks.register(() -> {
            rationingAutoCompressor = new RationingAutoCompressorBlock(ModBlocks.defaultProperties());
            return rationingAutoCompressor;
        }, () -> ModBlocks.itemBlock(rationingAutoCompressor), ModBlocks.id("rationing_auto_compressor"));
        compressedBlocks = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])CompressedBlockType.values(), (T it) -> "compressed_" + it, CompressedBlock::new);
        heavySieves = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])HeavySieveType.values(), (T it) -> it + "_heavy_sieve", HeavySieveBlock::new);
        woodenCrucibles = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])WoodenCrucibleType.values(), (T it) -> it + "_crucible", WoodenCrucibleBlock::new);
        baits = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])BaitType.values(), (T it) -> it + "_bait", BaitBlock::new);
    }

    private static <T extends Enum<T>> Block[] registerEnumBlock(BalmBlocks blocks, T[] types, Function<String, String> nameFactory, BiFunction<T, BlockBehaviour.Properties, Block> factory) {
        Block[] blockArray = new Block[types.length];
        for (Object type : types) {
            blocks.register(() -> {
                Block block = (Block)factory.apply(type, ModBlocks.defaultProperties());
                blockArray[type.ordinal()] = block;
                return block;
            }, () -> ModBlocks.itemBlock(blockArray[type.ordinal()]), ModBlocks.id(nameFactory.apply(((StringRepresentable)type).getSerializedName())));
        }
        return blockArray;
    }

    private static BlockItem itemBlock(Block block) {
        return new BlockItem(block, Balm.getItems().itemProperties());
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)path);
    }

    private static BlockBehaviour.Properties defaultProperties() {
        return Balm.getBlocks().blockProperties();
    }
}

