/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.HeavySieveType;
import net.blay09.mods.excompressum.block.entity.HeavySieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HeavySieveBlock
extends BaseEntityBlock {
    public static final MapCodec<HeavySieveBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)HeavySieveType.CODEC.fieldOf("type").forGetter(HeavySieveBlock::getType), (App)HeavySieveBlock.propertiesCodec()).apply((Applicative)it, HeavySieveBlock::new));
    private static final VoxelShape BOUNDING_BOX = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)0.75, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.125, (double)0.5, (double)0.125), Shapes.box((double)0.0625, (double)0.0, (double)0.875, (double)0.125, (double)0.5, (double)0.9375), Shapes.box((double)0.875, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.125), Shapes.box((double)0.875, (double)0.0, (double)0.875, (double)0.9375, (double)0.5, (double)0.9375)});
    public static final BooleanProperty WITH_MESH = BooleanProperty.create((String)"with_mesh");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final HeavySieveType type;

    public HeavySieveBlock(HeavySieveType type, BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public HeavySieveType getType() {
        return this.type;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WITH_MESH, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HeavySieveBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof HeavySieveBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        HeavySieveBlockEntity heavySieve = (HeavySieveBlockEntity)blockEntity;
        SieveMeshRegistryEntry sieveMesh = SieveMeshRegistry.getEntry(itemStack);
        if (sieveMesh != null && heavySieve.getMeshStack().isEmpty()) {
            heavySieve.setMeshStack(player.getAbilities().instabuild ? ContainerUtils.copyStackWithSize((ItemStack)itemStack, (int)1) : itemStack.split(1));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (heavySieve.addSiftable(player, itemStack)) {
            level.playSound(null, pos, SoundEvents.GRAVEL_STEP, SoundSource.BLOCKS, 0.5f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        ItemStack meshStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof HeavySieveBlockEntity)) {
            return InteractionResult.FAIL;
        }
        HeavySieveBlockEntity heavySieve = (HeavySieveBlockEntity)blockEntity;
        if (!level.isClientSide && player.isShiftKeyDown() && !(meshStack = heavySieve.getMeshStack()).isEmpty() && heavySieve.getCurrentStack().isEmpty()) {
            if (player.getInventory().add(meshStack)) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, meshStack));
            }
            heavySieve.setMeshStack(ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        if ((ExCompressumConfig.getActive().automation.allowHeavySieveAutomation || !Balm.getHooks().isFakePlayer(player)) && heavySieve.processContents(player)) {
            level.playSound(null, pos, SoundEvents.SAND_STEP, SoundSource.BLOCKS, 0.3f, 0.6f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, blockHitResult);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        HeavySieveBlockEntity heavySieve;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HeavySieveBlockEntity && !(heavySieve = (HeavySieveBlockEntity)blockEntity).getMeshStack().isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, heavySieve.getMeshStack()));
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? HeavySieveBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.heavySieve.get()), HeavySieveBlockEntity::clientTick) : HeavySieveBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.heavySieve.get()), HeavySieveBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

