/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.blay09.mods.excompressum.block.BaitType;
import net.blay09.mods.excompressum.block.entity.BaitBlockEntity;
import net.blay09.mods.excompressum.block.entity.EnvironmentalConditionResult;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaitBlock
extends BaseEntityBlock {
    public static final MapCodec<BaitBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)BaitType.CODEC.fieldOf("type").forGetter(BaitBlock::getBaitType), (App)BaitBlock.propertiesCodec()).apply((Applicative)it, BaitBlock::new));
    private static final VoxelShape BOUNDING_BOX = Shapes.box((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)0.1, (double)0.9);
    private final BaitType baitType;

    public BaitBlock(BaitType baitType, BlockBehaviour.Properties properties) {
        super(properties.strength(0.1f));
        this.baitType = baitType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BaitBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BaitBlockEntity)) {
            return InteractionResult.FAIL;
        }
        BaitBlockEntity bait = (BaitBlockEntity)blockEntity;
        EnvironmentalConditionResult environmentStatus = bait.checkSpawnConditions(true);
        if (!level.isClientSide) {
            MutableComponent chatComponent = Component.translatable((String)environmentStatus.langKey, (Object[])environmentStatus.params);
            chatComponent.withStyle(environmentStatus != EnvironmentalConditionResult.CanSpawn ? ChatFormatting.RED : ChatFormatting.GREEN);
            player.sendSystemMessage((Component)chatComponent);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (placer instanceof Player && (blockEntity = level.getBlockEntity(pos)) instanceof BaitBlockEntity) {
            BaitBlockEntity bait = (BaitBlockEntity)blockEntity;
            EnvironmentalConditionResult environmentStatus = bait.checkSpawnConditions(true);
            if (!level.isClientSide) {
                MutableComponent chatComponent = Component.translatable((String)environmentStatus.langKey, (Object[])environmentStatus.params);
                chatComponent.withStyle(environmentStatus != EnvironmentalConditionResult.CanSpawn ? ChatFormatting.RED : ChatFormatting.GREEN);
                placer.sendSystemMessage((Component)chatComponent);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BaitBlockEntity bait;
        BlockEntity blockEntity;
        if (!ExCompressumConfig.getActive().client.disableParticles && (blockEntity = level.getBlockEntity(pos)) instanceof BaitBlockEntity && (bait = (BaitBlockEntity)blockEntity).checkSpawnConditions(false) == EnvironmentalConditionResult.CanSpawn && rand.nextFloat() <= 0.2f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + rand.nextFloat()), (double)((float)pos.getY() + rand.nextFloat() * 0.5f), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.baitType == BaitType.SQUID) {
            tooltip.add((Component)Component.translatable((String)"tooltip.excompressum.baitPlaceInWater"));
        }
    }

    public BaitType getBaitType() {
        return this.baitType;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide ? BaitBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.bait.get()), BaitBlockEntity::serverTick) : null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

