/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.authlib.properties.PropertyMap;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.excompressum.block.IUglyfiable;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.autosieveskin.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.autosieveskin.WhitelistEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AutoSieveBaseBlock
extends BaseEntityBlock
implements IUglyfiable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty UGLY = ModBlockStateProperties.UGLY;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private ItemStack lastHoverStack = ItemStack.EMPTY;
    private String currentRandomName;

    protected AutoSieveBaseBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UGLY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UGLY, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractAutoSieveBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        AbstractAutoSieveBlockEntity autoSieve = (AbstractAutoSieveBlockEntity)blockEntity;
        Item heldItem = itemStack.getItem();
        if (itemStack.has(DataComponents.FOOD) && ExCompressumConfig.getActive().automation.allowAutoSieveFoodSpeedBoosts) {
            FoodProperties food = (FoodProperties)itemStack.get(DataComponents.FOOD);
            if (autoSieve.getFoodBoost() <= 1.0f) {
                ItemStack returnStack;
                autoSieve.applyFoodBoost(food);
                if (!player.getAbilities().instabuild && (returnStack = heldItem.finishUsingItem(itemStack, level, (LivingEntity)player)) != itemStack) {
                    player.setItemInHand(hand, returnStack);
                }
                level.levelEvent(2005, pos, 0);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (heldItem == Items.NAME_TAG && itemStack.has(DataComponents.CUSTOM_NAME)) {
            autoSieve.setSkinProfile(new ResolvableProfile(Optional.of(((Component)itemStack.get(DataComponents.CUSTOM_NAME)).getString()), Optional.empty(), new PropertyMap()));
            return ItemInteractionResult.CONSUME_PARTIAL;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            Balm.getNetworking().openGui(player, menuProvider);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, blockHitResult);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractAutoSieveBlockEntity) {
            AbstractAutoSieveBlockEntity autoSieve = (AbstractAutoSieveBlockEntity)blockEntity;
            if (newState.getBlock() != state.getBlock()) {
                Container container = autoSieve.getBackingContainer();
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ItemStack itemStack = container.getItem(i);
                    if (itemStack.isEmpty()) continue;
                    ItemEntity entityItem = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                    double motion = 0.05;
                    entityItem.setDeltaMovement(level.random.nextGaussian() * motion, 0.2, level.random.nextGaussian() * motion);
                    level.addFreshEntity((Entity)entityItem);
                }
                ItemStack currentStack = autoSieve.getCurrentStack();
                if (!currentStack.isEmpty()) {
                    ItemEntity entityItem = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), currentStack);
                    double motion = 0.05;
                    entityItem.setDeltaMovement(level.random.nextGaussian() * motion, 0.2, level.random.nextGaussian() * motion);
                    level.addFreshEntity((Entity)entityItem);
                }
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Container container;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (container = (Container)Balm.getProviders().getProvider(blockEntity, Container.class)) != null) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container);
        }
        return 0;
    }

    protected Component getSkinTooltip(String name) {
        return Component.translatable((String)"tooltip.excompressum.auto_sieve", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (profile != null) {
            tooltip.add(this.getSkinTooltip(profile.gameProfile().getName()));
        } else {
            if (this.currentRandomName == null) {
                this.updateRandomSkinName();
            }
            tooltip.add(this.getSkinTooltip(this.currentRandomName));
        }
        if (this.lastHoverStack != stack) {
            this.updateRandomSkinName();
            this.lastHoverStack = stack;
        }
    }

    private void updateRandomSkinName() {
        WhitelistEntry randomSkin = AutoSieveSkinRegistry.getRandomSkin();
        this.currentRandomName = randomSkin != null ? randomSkin.getName() : "Steve";
    }

    @Override
    public boolean uglify(@Nullable Player player, Level level, BlockPos pos, BlockState state, InteractionHand hand, Direction facing, Vec3 hitVec) {
        if (!((Boolean)state.getValue((Property)UGLY)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)UGLY, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        if (!((Boolean)state.getValue((Property)UGLY)).booleanValue() && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            float posX = (float)pos.getX() + 0.5f;
            float posY = (float)((double)((float)pos.getY() + 0.6f) + Math.random() * 0.25);
            float posZ = (float)pos.getZ() + 0.5f;
            float speed = 0.25f;
            float motionX = 0.0f * speed;
            float motionY = (float)((0.5 + Math.random() - 0.5) * (double)speed);
            float motionZ = 0.0f * speed;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)posX, (double)posY, (double)posZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    public abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? AutoSieveBaseBlock.createTickerHelper(type, this.getBlockEntityType(), AbstractAutoSieveBlockEntity::clientTick) : AutoSieveBaseBlock.createTickerHelper(type, this.getBlockEntityType(), AbstractAutoSieveBlockEntity::serverTick);
    }
}

