/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.serialization.MapCodec;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.excompressum.block.IUglyfiable;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlock
extends BaseEntityBlock
implements IUglyfiable {
    public static final MapCodec<AutoHammerBlock> CODEC = AutoHammerBlock.simpleCodec(AutoHammerBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty UGLY = ModBlockStateProperties.UGLY;

    public AutoHammerBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f).noOcclusion().isValidSpawn((a, b, c, d) -> false).isRedstoneConductor((a, b, c) -> (Boolean)a.getValue((Property)UGLY)).isSuffocating((a, b, c) -> false).isViewBlocking((a, b, c) -> false));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UGLY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UGLY});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutoHammerBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            Balm.getNetworking().openGui(player, menuProvider);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AutoHammerBlockEntity) {
            AutoHammerBlockEntity autoHammer = (AutoHammerBlockEntity)blockEntity;
            if (state.getBlock() != newState.getBlock()) {
                DefaultContainer itemHandler = autoHammer.getBackingContainer();
                for (int i = 0; i < itemHandler.getContainerSize(); ++i) {
                    ItemStack itemStack = itemHandler.getItem(i);
                    if (itemStack.isEmpty()) continue;
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack));
                }
                ItemStack currentStack = autoHammer.getCurrentStack();
                if (!currentStack.isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), currentStack));
                }
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Container container;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (container = (Container)Balm.getProviders().getProvider(blockEntity, Container.class)) != null) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container);
        }
        return 0;
    }

    @Override
    public boolean uglify(@Nullable Player player, Level level, BlockPos pos, BlockState state, InteractionHand hand, Direction facing, Vec3 hitVec) {
        if (!((Boolean)state.getValue((Property)UGLY)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)UGLY, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateRedstoneState(level, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateRedstoneState(level, pos);
    }

    private void updateRedstoneState(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AutoHammerBlockEntity) {
            AutoHammerBlockEntity autoHammer = (AutoHammerBlockEntity)blockEntity;
            autoHammer.setDisabledByRedstone(level.hasNeighborSignal(pos));
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide ? AutoHammerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.autoHammer.get()), AutoHammerBlockEntity::serverTick) : AutoHammerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.autoHammer.get()), AutoHammerBlockEntity::clientTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

