/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockItem;
import com.davenonymous.bonsaitrees.setup.ModItems;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BonsaiHooks {
    public static final Set<String> validEnchantments = BonsaiPotBlockItem.validEnchantments.stream().map(enchantmentResourceKey -> {
        String id = enchantmentResourceKey.location().getPath();
        return "enchantment.minecraft." + id;
    }).collect(Collectors.toSet());

    public static void canEnchantHook(ItemStack stack, Component description, CallbackInfoReturnable<Boolean> cir) {
        if (!stack.is((Item)ModItems.BONSAI_POT_ITEM.get()) && !stack.is((Item)ModItems.BONSAI_POT_SMALL_ITEM.get())) {
            return;
        }
        ComponentContents componentContents = description.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents content = (TranslatableContents)componentContents;
            String enchantmentKey = content.getKey();
            cir.setReturnValue((Object)validEnchantments.contains(enchantmentKey));
        }
    }
}

