/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.util;

@FunctionalInterface
public interface EasingFunction {
    public double apply(double var1);

    public static EasingFunction chained(EasingFunction ... easings) {
        return progress -> {
            double partLength = 1.0 / (double)easings.length;
            int index = (int)(progress / partLength);
            if (index >= easings.length) {
                index = easings.length - 1;
            }
            EasingFunction easing = easings[index];
            double localProgress = (progress - (double)index * partLength) / partLength;
            double result = easing.apply(localProgress);
            return result * partLength + (double)index * partLength;
        };
    }

    public static EasingFunction linear() {
        return progress -> progress;
    }

    public static EasingFunction easeInSquare() {
        return progress -> progress * progress;
    }

    public static EasingFunction easeOutSquare() {
        return progress -> progress * (2.0 - progress);
    }

    public static EasingFunction easeInOutSquare() {
        return progress -> {
            if (progress < 0.5) {
                return 2.0 * progress * progress;
            }
            return -1.0 + (4.0 - 2.0 * progress) * progress;
        };
    }

    public static EasingFunction easeInCubic() {
        return progress -> progress * progress * progress;
    }

    public static EasingFunction easeOutCubic() {
        return progress -> (progress -= 1.0) * progress * progress + 1.0;
    }

    public static EasingFunction easeInOutCubic() {
        return progress -> {
            if (progress < 0.5) {
                return 4.0 * progress * progress * progress;
            }
            double f = 2.0 * progress - 2.0;
            return 0.5 * f * f * f + 1.0;
        };
    }

    public static EasingFunction easeInQuart() {
        return progress -> progress * progress * progress * progress;
    }

    public static EasingFunction easeOutQuart() {
        return progress -> 1.0 - (progress -= 1.0) * progress * progress * progress;
    }

    public static EasingFunction easeInOutQuart() {
        return progress -> {
            if (progress < 0.5) {
                return 8.0 * progress * progress * progress * progress;
            }
            double f = 2.0 * progress - 2.0;
            return -0.5 * (f * f * f * f - 2.0);
        };
    }

    public static EasingFunction easeInSine() {
        return progress -> 1.0 - Math.cos(progress * Math.PI / 2.0);
    }

    public static EasingFunction easeOutSine() {
        return progress -> Math.sin(progress * Math.PI / 2.0);
    }

    public static EasingFunction easeInOutSine() {
        return progress -> 0.5 * (1.0 - Math.cos(Math.PI * progress));
    }

    public static EasingFunction easeInExpo() {
        return progress -> progress == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * (progress - 1.0));
    }

    public static EasingFunction easeOutExpo() {
        return progress -> progress == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * progress);
    }

    public static EasingFunction easeInOutExpo() {
        return progress -> {
            if (progress == 0.0) {
                return 0.0;
            }
            if (progress == 1.0) {
                return 1.0;
            }
            if (progress < 0.5) {
                return 0.5 * Math.pow(2.0, 20.0 * progress - 10.0);
            }
            return -0.5 * Math.pow(2.0, -20.0 * progress + 10.0) + 1.0;
        };
    }
}

