/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.event.ValueChangedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetList;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class WidgetTree
extends WidgetList {
    private List<WidgetTreeNode> rootNodes = new ArrayList<WidgetTreeNode>();
    private int indentPixels = 10;
    private Predicate<WidgetTreeNode> filter = null;

    public WidgetTree setFilter(Predicate<WidgetTreeNode> filter) {
        this.filter = filter;
        return this;
    }

    public WidgetTree setIndentPixels(int indentPixels) {
        this.indentPixels = indentPixels;
        return this;
    }

    public WidgetTreeNode addRootNode(Widget widget) {
        WidgetTreeNode node = new WidgetTreeNode(widget);
        node.setIndentPixels(this.indentPixels);
        node.setExpanded(true);
        this.rootNodes.add(node);
        return node;
    }

    private void addNode(WidgetTreeNode node, int indent) {
        if (node.children.isEmpty() && this.filter != null && !this.filter.test(node)) {
            return;
        }
        WidgetTreeNode.TreeNodeEntryPanel indented = node.getIndented(indent, this.width - 15);
        indented.addListener(ValueChangedEvent.class, (event, widget) -> {
            this.buildListFromRootNodes();
            return WidgetEventResult.HANDLED;
        });
        this.addListEntry(indented);
    }

    private void addToListFromNode(WidgetTreeNode node, int indent) {
        this.addNode(node, indent);
        if (node.isExpanded()) {
            for (WidgetTreeNode child : node.children) {
                this.addToListFromNode(child, indent + 1);
            }
        }
    }

    public void buildListFromRootNodes() {
        this.clear();
        for (WidgetTreeNode node : this.rootNodes) {
            this.addToListFromNode(node, 0);
        }
    }
}

