/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.GUIHelper;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseClickEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.TabChangedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetPanel;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetTabsPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class WidgetTabsButton
extends WidgetPanel {
    public WidgetTabsPanel parent;
    public WidgetPanel page;
    public WidgetTabsPanel.TabDockEdge edge;
    public Widget buttonImage;

    public WidgetTabsButton(WidgetTabsPanel parent, WidgetPanel page, Widget buttonImage, WidgetTabsPanel.TabDockEdge edge) {
        this.parent = parent;
        this.page = page;
        this.buttonImage = buttonImage;
        this.edge = edge;
        this.addClickListener();
    }

    public void addClickListener() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            this.setActive(true);
            return WidgetEventResult.HANDLED;
        });
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void setActive(boolean fireEvent) {
        this.parent.activePanel.setVisible(false);
        this.page.setVisible(true);
        WidgetPanel tmpOld = this.parent.activePanel;
        this.parent.activePanel = this.page;
        if (fireEvent) {
            this.parent.fireEvent(new TabChangedEvent(tmpOld, this.page));
        }
    }

    private boolean isActive() {
        return this.parent.activePanel == this.page;
    }

    private boolean isFirst() {
        return this.parent.pages.indexOf(this.page) == 0;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        pGuiGraphics.pose().pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUIHelper.tabIcons);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonWidth = 32;
        if (!this.isActive()) {
            buttonWidth = 28;
        }
        int buttonHeight = 28;
        int textureY = this.isFirst() ? 28 : 56;
        int textureX = this.isActive() ? 32 : 0;
        int x = 0;
        int y = 0;
        int iconX = 9;
        int iconY = 5;
        if (this.edge == WidgetTabsPanel.TabDockEdge.NORTH) {
            buttonHeight = 31;
            buttonWidth = 31;
            if (this.isActive()) {
                textureY = 104;
                textureX = 0;
            } else {
                textureY = 104;
                textureX = 31;
            }
            iconX = 7;
            iconY = 7;
        }
        if (!this.isActive()) {
            iconY += 2;
        }
        pGuiGraphics.blit(GUIHelper.tabIcons, x, y, textureX, textureY, buttonWidth, buttonHeight);
        this.buttonImage.setPosition(iconX, iconY);
        this.buttonImage.shiftAndDraw(pGuiGraphics, screen);
        pGuiGraphics.pose().popPose();
    }
}

