/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.lib.gui.event.VisibilityChangedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class WidgetSlot
extends SlotItemHandler {
    private boolean enabled;
    private final ResourceLocation id;
    private boolean locked = false;
    private int maxStackSize = 64;
    private boolean blockManualInsert = false;

    public WidgetSlot(ResourceLocation slotId, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.id = slotId;
        this.enabled = true;
    }

    public WidgetSlot setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public void bindToWidget(Widget widget) {
        widget.addListener(VisibilityChangedEvent.class, (event, widget1) -> {
            this.setEnabled((Boolean)event.newValue != false && widget.areAllParentsVisible());
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public ResourceLocation getGroupId() {
        return this.id;
    }

    public boolean matches(ResourceLocation slotId) {
        return this.id.equals((Object)slotId);
    }

    public boolean blocksManualInsert() {
        return this.blockManualInsert;
    }

    public WidgetSlot setBlockManualInsert(boolean blockManualInsert) {
        this.blockManualInsert = blockManualInsert;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WidgetSlot setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public WidgetSlot setLocked(boolean locked) {
        this.locked = locked;
        return this;
    }

    public boolean isActive() {
        return this.isEnabled();
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        if (this.locked) {
            return;
        }
        if (stack.getCount() <= stack.getMaxStackSize()) {
            super.onTake(thePlayer, stack);
            return;
        }
        int total = stack.getCount() + this.getItem().getCount();
        ItemStack before = stack.copy();
        ItemStack after = before.copy();
        after.setCount(total - before.getMaxStackSize());
        stack.setCount(before.getMaxStackSize());
        this.set(after);
        this.setChanged();
    }

    public boolean mayPlace(ItemStack stack) {
        if (this.blockManualInsert) {
            return false;
        }
        return super.mayPlace(stack);
    }

    public boolean allowModification(Player player) {
        if (this.locked || !this.enabled) {
            return false;
        }
        if (player != null) {
            ItemStack mouseStack = player.getInventory().getSelected();
            if (mouseStack.isEmpty()) {
                return true;
            }
            return this.getItem().getCount() <= this.getItem().getMaxStackSize();
        }
        return true;
    }

    public int getMaxStackSize(@Nonnull ItemStack stack) {
        return this.maxStackSize;
    }
}

