/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.compatibility.jei;

import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiRecipe;
import com.davenonymous.bonsaitrees.setup.cache.JeiRecipeCache;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BonsaiRecipeManager
implements ISimpleRecipeManagerPlugin<BonsaiRecipe> {
    public boolean isHandledInput(ITypedIngredient<?> input) {
        if (input.getItemStack().isEmpty()) {
            return false;
        }
        Item item = ((ItemStack)input.getItemStack().get()).getItem();
        return JeiRecipeCache.RECIPES_BY_INPUT.containsKey(item);
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        if (output.getItemStack().isEmpty()) {
            return false;
        }
        Item item = ((ItemStack)output.getItemStack().get()).getItem();
        return JeiRecipeCache.RECIPES_BY_OUTPUT.containsKey(item);
    }

    public List<BonsaiRecipe> getRecipesForInput(ITypedIngredient<?> input) {
        if (input.getItemStack().isEmpty()) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)input.getItemStack().get();
        Item item = stack.getItem();
        return JeiRecipeCache.RECIPES_BY_INPUT.getOrDefault(item, Collections.emptySet()).stream().toList();
    }

    public List<BonsaiRecipe> getRecipesForOutput(ITypedIngredient<?> output) {
        if (output.getItemStack().isEmpty()) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)output.getItemStack().get();
        Item item = stack.getItem();
        return JeiRecipeCache.RECIPES_BY_OUTPUT.getOrDefault(item, Collections.emptySet()).stream().toList();
    }

    public List<BonsaiRecipe> getAllRecipes() {
        return JeiRecipeCache.ALL_RECIPES;
    }
}

