/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.compatibility.jei;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotScreen;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiCategory;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiRecipe;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiRecipeManager;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiSubtypeInterpreter;
import com.davenonymous.bonsaitrees.compatibility.jei.SoilTypeCategory;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.davenonymous.bonsaitrees.setup.cache.SoilTypeCache;
import com.davenonymous.bonsaitrees.setup.config.ClientConfig;
import com.davenonymous.bonsaitrees.setup.config.DebugConfig;
import com.davenonymous.bonsaitrees.setup.data.SoilType;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class BonsaiJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = BonsaiTrees.resource("jei");
    public static final RecipeType<BonsaiRecipe> BONSAIS = RecipeType.create((String)"bonsaitrees4", (String)"bonsais", BonsaiRecipe.class);
    public static final RecipeType<SoilType> SOIL_TYPES = RecipeType.create((String)"bonsaitrees4", (String)"soils", SoilType.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BonsaiCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoilTypeCategory(registration.getJeiHelpers())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Stream<Object> soilTypeStream = SoilTypeCache.RESOURCE_BY_SOIL.keySet().stream();
        if (!DebugConfig.showUnusedSoilRecipesInJEI) {
            soilTypeStream = soilTypeStream.filter(SoilType::hasSoils).filter(SoilType::hasBonsais);
        }
        registration.addRecipes(SOIL_TYPES, soilTypeStream.toList());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(BONSAIS, (ISimpleRecipeManagerPlugin)new BonsaiRecipeManager());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)ModBlocks.BONSAI_POT.get(), new RecipeType[]{BONSAIS});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.BONSAI_POT_SMALL.get(), new RecipeType[]{BONSAIS});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.BONSAI_POT.get(), new RecipeType[]{SOIL_TYPES});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.BONSAI_POT_SMALL.get(), new RecipeType[]{SOIL_TYPES});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BonsaiPotScreen.class, 86, 40, 22, 15, new RecipeType[]{BONSAIS, SOIL_TYPES});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (ClientConfig.showJEISubtypes) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Block)ModBlocks.BONSAI_POT.get()).asItem(), (ISubtypeInterpreter)new BonsaiSubtypeInterpreter());
        }
    }
}

