/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.compatibility.jei;

import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiJEIPlugin;
import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiRecipe;
import com.davenonymous.bonsaitrees.datacomponents.CamouflageDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SaplingDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SoilDataComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.TranslatableTooltipComponent;
import com.davenonymous.bonsaitrees.lib.util.LootHelper;
import com.davenonymous.bonsaitrees.lib.util.Sorting;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import com.davenonymous.bonsaitrees.setup.ModModelLoaders;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.LootCache;
import com.davenonymous.bonsaitrees.setup.config.DebugConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;

public class BonsaiCategory
implements IRecipeCategory<BonsaiRecipe> {
    private final IJeiHelpers jeiHelpers;
    private final ITickTimer rotationTickTimer;

    public BonsaiCategory(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
        this.rotationTickTimer = this.jeiHelpers.getGuiHelper().createTickTimer(360, 360, false);
    }

    public int getWidth() {
        return 155;
    }

    public int getHeight() {
        return 40;
    }

    public RecipeType<BonsaiRecipe> getRecipeType() {
        return BonsaiJEIPlugin.BONSAIS;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.bonsaitrees4.bonsais.title");
    }

    @Nullable
    public IDrawable getIcon() {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.BONSAI_POT.get());
        stack.set((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get(), (Object)new CamouflageDataComponent(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_GRAY_CONCRETE_POWDER)));
        List<Item> saplingItems = Sorting.toSortedList(BonsaiCache.BONSAI_BY_ITEM.keySet());
        if (!saplingItems.isEmpty()) {
            int index = ((int)Minecraft.getInstance().level.getGameTime() >> 4) % saplingItems.size();
            Item saplingToShow = saplingItems.get(index);
            stack.set((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get(), (Object)new SaplingDataComponent(saplingToShow.builtInRegistryHolder().getKey().location(), Optional.of(Float.valueOf(1.0f))));
        }
        stack.set((DataComponentType)ModDataComponents.SOIL_COMPONENT.get(), (Object)new SoilDataComponent(new ItemStack((ItemLike)Blocks.GRASS_BLOCK)));
        return this.jeiHelpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BonsaiRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 1).setSlotName("sapling").addItemStacks(List.of(recipe.sapling().getDefaultInstance()));
        builder.addInputSlot(1, 20).setSlotName("soil").addItemStacks(recipe.info().validSoilItems(Minecraft.getInstance().level.registryAccess()).stream().map(ItemStack::new).toList());
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)recipe.sapling());
        List<LootHelper.LootTableDrop> drops = LootCache.DROPS_BY_BONSAI.get(itemId);
        if (drops == null) {
            return;
        }
        int targetSlot = 0;
        for (int slot = 0; slot < drops.size() && targetSlot < 8; ++targetSlot, ++slot) {
            LootHelper.LootTableDrop lootDrop = drops.get(slot);
            ItemStack drop = lootDrop.stack().copy();
            if (!DebugConfig.showRollsAsCountInJEI) {
                drop.setCount(1);
            }
            ((IRecipeSlotBuilder)builder.addOutputSlot(81 + 19 * (targetSlot % 4), 1 + 19 * (targetSlot / 4)).setSlotName("output_" + targetSlot).addItemStack(drop)).addRichTooltipCallback((recipeSlotView, tooltip) -> this.richTooltipCallback(recipeSlotView, tooltip, lootDrop));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void richTooltipCallback(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip, LootHelper.LootTableDrop lootDrop) {
        if (lootDrop.conditions().isEmpty()) {
            return;
        }
        LinkedList<TooltipComponent> conditionTooltips = new LinkedList<TooltipComponent>();
        float totalRandomChance = 1.0f;
        for (LootItemCondition condition : lootDrop.conditions()) {
            if (condition instanceof LootItemRandomChanceCondition) {
                NumberProvider chanceProvider;
                LootItemRandomChanceCondition lootItemRandomChanceCondition = (LootItemRandomChanceCondition)condition;
                try {
                    NumberProvider numberProvider;
                    chanceProvider = numberProvider = lootItemRandomChanceCondition.chance();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (chanceProvider instanceof ConstantValue) {
                    ConstantValue constantValue = (ConstantValue)chanceProvider;
                    {
                        float f;
                        float value = f = constantValue.value();
                        totalRandomChance *= value;
                        continue;
                    }
                }
            }
            if (condition instanceof BonusLevelTableCondition) {
                BonusLevelTableCondition bonusCondition = (BonusLevelTableCondition)condition;
                continue;
            }
            TooltipComponent conditionTooltip = LootHelper.interpretCondition(condition);
            if (conditionTooltip == null) continue;
            conditionTooltips.add(conditionTooltip);
        }
        if (DebugConfig.showChances) {
            int chancePercent = Math.round(Math.clamp(totalRandomChance, 0.0f, 1.0f) * 100.0f);
            tooltip.add((TooltipComponent)StringTooltipComponent.gray(I18n.get((String)"jei.bonsaitrees4.recipes.chance", (Object[])new Object[]{chancePercent})));
            int rolls = lootDrop.stack().getCount();
            tooltip.add((TooltipComponent)StringTooltipComponent.gray(I18n.get((String)"jei.bonsaitrees4.recipes.rolls", (Object[])new Object[]{rolls})));
        }
        if (conditionTooltips.isEmpty()) {
            return;
        }
        tooltip.add((TooltipComponent)StringTooltipComponent.white(""));
        tooltip.add((TooltipComponent)new TranslatableTooltipComponent("jei.bonsaitrees4.recipes.requires"));
        conditionTooltips.forEach(arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
    }

    public void draw(BonsaiRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MultiBlockFakeLevel fakeLevel;
        VertexBuffer treeVbo;
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        IDrawableStatic slotDrawable = this.jeiHelpers.getGuiHelper().getSlotDrawable();
        slotDrawable.draw(guiGraphics, 0, 0);
        slotDrawable.draw(guiGraphics, 0, 19);
        for (int i = 0; i < 8; ++i) {
            slotDrawable.draw(guiGraphics, 80 + 19 * (i % 4), 19 * (i / 4));
        }
        ResourceLocation modelId = BonsaiCache.BONSAI_BY_ITEM.get(recipe.sapling()).model();
        if (!ModModelLoaders.MODEL_MAP.containsKey(modelId)) {
            return;
        }
        ModelResourceLocation treeModelId = ModModelLoaders.MODEL_MAP.get(modelId);
        MultiBlockModel multiBlockModel = (MultiBlockModel)Minecraft.getInstance().getModelManager().getModel(treeModelId);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(50.0f, 38.0f, 100.0f);
        guiGraphics.pose().scale(32.0f, 32.0f, 32.0f);
        guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(155.0), 1.0f, 0.0f, 0.0f)));
        if (this.rotationTickTimer != null) {
            guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(this.rotationTickTimer.getValue()), 0.0f, 1.0f, 0.0f)));
        }
        if ((treeVbo = ModModelLoaders.getVbo(modelId, multiBlockModel, fakeLevel = new MultiBlockFakeLevel(multiBlockModel, (BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO), BlockPos.ZERO)) != null && !treeVbo.isInvalid()) {
            Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            viewMatrix.mul((Matrix4fc)guiGraphics.pose().last().pose());
            ModModelLoaders.renderTypeForModels.setupRenderState();
            ShaderInstance shader = RenderSystem.getShader();
            shader.setDefaultUniforms(VertexFormat.Mode.QUADS, viewMatrix, projectionMatrix, Minecraft.getInstance().getWindow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setupShaderLights((ShaderInstance)shader);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            treeVbo.bind();
            GL11.glFrontFace((int)2304);
            treeVbo.drawWithShader(viewMatrix, projectionMatrix, shader);
            GL11.glFrontFace((int)2305);
            VertexBuffer.unbind();
        }
        guiGraphics.pose().popPose();
    }
}

