/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.command.list;

import com.davenonymous.bonsaitrees.command.arguments.SaplingArgument;
import com.davenonymous.bonsaitrees.lib.util.LootHelper;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ListDrops
implements Command<CommandSourceStack> {
    private static final ListDrops INSTANCE = new ListDrops();

    private ListDrops() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.literal((String)"drops").then(((RequiredArgumentBuilder)Commands.argument((String)"sapling", (ArgumentType)SaplingArgument.saplingArgument()).requires(cs -> cs.hasPermission(0))).executes((Command)INSTANCE));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation inputSapling = (ResourceLocation)context.getArgument("sapling", ResourceLocation.class);
        BonsaiInfo bonsai = BonsaiCache.BONSAI_BY_RESOURCE.get(inputSapling);
        if (bonsai == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("No bonsai found for: " + String.valueOf(inputSapling))));
            return 0;
        }
        ResourceKey<LootTable> lootTableId = bonsai.lootTable();
        LootTable lootTable = ((CommandSourceStack)context.getSource()).getLevel().getServer().reloadableRegistries().getLootTable(lootTableId);
        if (lootTable == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("No loot table found for: " + String.valueOf(lootTableId))));
            return 0;
        }
        LootParams lootParams = new LootParams.Builder(((CommandSourceStack)context.getSource()).getLevel()).create(LootContextParamSets.EMPTY);
        List<LootHelper.LootTableDrop> drops = LootHelper.getLootTableDrops(lootTableId, ((CommandSourceStack)context.getSource()).getLevel(), new LootContext.Builder(lootParams).create(Optional.empty()));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(drops.size() + " drops for: " + String.valueOf(inputSapling))), false);
        for (LootHelper.LootTableDrop lootDrop : drops) {
            ItemStack drop = lootDrop.stack();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ((ItemStack)drop).getHoverName(), false);
            List<LootItemCondition> conditions = lootDrop.conditions();
            if (conditions.isEmpty()) continue;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"  Conditions:"), false);
            for (LootItemCondition condition : conditions) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("   - " + condition.getClass().getSimpleName())), false);
            }
        }
        return 0;
    }
}

