/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client.multiblock;

import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockBakedQuad;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockGeometry;
import com.davenonymous.bonsaitrees.multiblock.MultiBlockGeometryBase;
import com.davenonymous.bonsaitrees.setup.config.ClientConfig;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class MultiBlockModel
implements IDynamicBakedModel {
    private static final Material MISSING_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
    private final Map<Direction, List<BakedQuad>> cache = new HashMap<Direction, List<BakedQuad>>();
    private final int scaleToBlocks;
    private final float scale;
    public final MultiBlockGeometry geometry;
    public final Map<BlockPos, MultiBlockGeometryBase.Voxel> blocks;

    public MultiBlockModel(MultiBlockGeometry geometry) {
        this.geometry = geometry;
        this.blocks = geometry.voxels();
        this.scaleToBlocks = geometry.scaleToBlocks();
        int width = 0;
        int height = 0;
        int depth = 0;
        for (BlockPos pos : this.blocks.keySet()) {
            if (pos.getX() > width) {
                width = pos.getX();
            }
            if (pos.getY() > height) {
                height = pos.getY();
            }
            if (pos.getZ() <= depth) continue;
            depth = pos.getZ();
        }
        int dim = Math.max(height, Math.max(width, depth));
        if (height > 6 || ++dim <= 4) {
            dim = Math.max(6, dim);
        }
        this.scale = (float)this.scaleToBlocks / (float)dim;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource, ModelData modelData, @Nullable RenderType renderType) {
        if (this.cache.isEmpty() || !this.cache.containsKey(direction) || ClientConfig.disableModelCache) {
            this.cache.put(direction, new ArrayList());
            Vector3f centerOffset = new Vector3f((float)this.geometry.trunkPos.getX() + 0.5f, 0.0f, (float)this.geometry.trunkPos.getZ() + 0.5f);
            for (MultiBlockGeometryBase.Voxel voxel : this.blocks.values()) {
                MultiBlockGeometryBase.Voxel relativeState;
                if (ClientConfig.minimalQuads && direction != null && this.blocks.containsKey(voxel.pos().relative(direction)) && (relativeState = this.blocks.get(voxel.pos().relative(direction))) != null && relativeState.state().getBlock() == voxel.state().getBlock()) continue;
                BakedModel model = voxel.model();
                List modelQuads = voxel.model().getQuads(voxel.state(), direction, randomSource, modelData, null);
                Transformation translate = new Transformation(new Matrix4f().translate((float)voxel.pos().getX(), (float)voxel.pos().getY(), (float)voxel.pos().getZ()));
                Transformation translateCenter = new Transformation(new Matrix4f().translate(-centerOffset.x, 0.0f, -centerOffset.z));
                Transformation scale = new Transformation(new Matrix4f().scale(this.scale));
                IQuadTransformer translator = QuadTransformers.applying((Transformation)translate);
                IQuadTransformer centerer = QuadTransformers.applying((Transformation)translateCenter);
                IQuadTransformer scaler = QuadTransformers.applying((Transformation)scale);
                List transformedQuads = translator.andThen(centerer).andThen(scaler).process(modelQuads);
                for (BakedQuad quad : transformedQuads) {
                    this.cache.get(direction).add(MultiBlockBakedQuad.of(quad, voxel.state(), voxel.pos()));
                }
            }
        }
        return this.cache.get(direction);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return MISSING_TEXTURE.sprite();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.TRANSLUCENT});
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

