/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlock;
import com.davenonymous.bonsaitrees.client.PotModelGeometry;
import com.davenonymous.bonsaitrees.lib.BakedModelHelper;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.SoilInfoWithTexture;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;

public class PotModel
extends BakedModelWrapper<BakedModel> {
    public final Vec3 treeOffset;
    public final float treeScale;
    public final List<BlockElement> elements;
    public final List<PotModelGeometry.SoilElement> soilElements;
    public final Map<Block, List<BakedQuad>> camouflageQuads = new HashMap<Block, List<BakedQuad>>();
    public final Map<Block, List<BakedQuad>> soilQuads = new HashMap<Block, List<BakedQuad>>();
    public final Map<Fluid, List<BakedQuad>> fluidSoilQuads = new HashMap<Fluid, List<BakedQuad>>();
    public final Map<Item, List<BakedQuad>> itemSoilQuads = new HashMap<Item, List<BakedQuad>>();

    public PotModel(BakedModel originalModel, Vec3 treeOffset, float treeScale, List<BlockElement> elements, List<PotModelGeometry.SoilElement> soilElements) {
        super(originalModel);
        this.treeOffset = treeOffset;
        this.treeScale = treeScale;
        this.elements = elements;
        this.soilElements = soilElements;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return super.getParticleIcon(data);
    }

    private List<BakedQuad> getSoilQuadsWithTexture(TextureAtlasSprite sprite, int tintIndex, int tintColor) {
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tintColor & 0xFF) / 255.0f;
        ArrayList<BakedQuad> soilQuadsResult = new ArrayList<BakedQuad>();
        for (PotModelGeometry.SoilElement soilElement : this.soilElements) {
            Vec3 from = soilElement.from();
            Vec3 to = soilElement.to();
            double minX = Math.min(from.x, to.x) / 16.0;
            double maxX = Math.max(from.x, to.x) / 16.0;
            double minY = Math.min(from.y, to.y) / 16.0;
            double maxY = Math.max(from.y, to.y) / 16.0;
            double minZ = Math.min(from.z, to.z) / 16.0;
            double maxZ = Math.max(from.z, to.z) / 16.0;
            BakedQuad baked = BakedModelHelper.quad(BakedModelHelper.v(minX, maxY, minZ), BakedModelHelper.uv(minX, minZ), BakedModelHelper.v(minX, maxY, maxZ), BakedModelHelper.uv(minX, maxZ), BakedModelHelper.v(maxX, maxY, maxZ), BakedModelHelper.uv(maxX, maxZ), BakedModelHelper.v(maxX, maxY, minZ), BakedModelHelper.uv(maxX, minZ), r, g, b, 1.0f, tintIndex, sprite);
            soilQuadsResult.add(baked);
        }
        return soilQuadsResult;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        Item item;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.originalModel.getQuads(state, side, rand, extraData, renderType));
        if (quads.isEmpty()) {
            return quads;
        }
        ArrayList<BakedQuad> finalQuads = new ArrayList<BakedQuad>();
        if (extraData.has(BonsaiPotBlock.SOIL)) {
            Block soilBlock = (Block)extraData.get(BonsaiPotBlock.SOIL);
            if (!this.soilQuads.containsKey(soilBlock)) {
                BlockState soilState = soilBlock.defaultBlockState();
                BakedModel soilModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(soilState);
                List originalQuads = soilModel.getQuads(soilState, Direction.UP, rand, extraData, renderType);
                ArrayList<BakedQuad> soilQuadsResult = new ArrayList<BakedQuad>();
                if (!originalQuads.isEmpty()) {
                    BakedQuad soilQuad = (BakedQuad)originalQuads.getFirst();
                    TextureAtlasSprite soilTexture = soilQuad.getSprite();
                    int soilTint = 0;
                    int tintColor = Minecraft.getInstance().getBlockColors().getColor(soilState, null, null, soilTint);
                    soilQuadsResult.addAll(this.getSoilQuadsWithTexture(soilTexture, soilTint, tintColor));
                }
                this.soilQuads.put(soilBlock, soilQuadsResult);
            }
            finalQuads.addAll((Collection)this.soilQuads.get(soilBlock));
        }
        if (extraData.has(BonsaiPotBlock.FLUID_SOIL)) {
            Fluid fluid = (Fluid)extraData.get(BonsaiPotBlock.FLUID_SOIL);
            IClientFluidTypeExtensions fluidStyle = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStyle.getStillTexture());
            int tintColor = fluidStyle.getTintColor();
            if (!this.fluidSoilQuads.containsKey(fluid)) {
                this.fluidSoilQuads.put(fluid, this.getSoilQuadsWithTexture(sprite, 0, tintColor));
            }
            finalQuads.addAll((Collection<BakedQuad>)this.fluidSoilQuads.get(fluid));
        }
        if (extraData.has(BonsaiPotBlock.ITEM_SOIL) && SoilCache.SOIL_BY_ITEM.containsKey(item = (Item)extraData.get(BonsaiPotBlock.ITEM_SOIL))) {
            Set<SoilInfoWithTexture> itemDetails;
            Optional itemDetailsFirst;
            if (!this.itemSoilQuads.containsKey(item) && (itemDetailsFirst = (itemDetails = SoilCache.SOIL_BY_ITEM.get(item)).stream().findFirst()).isPresent()) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(((SoilInfoWithTexture)itemDetailsFirst.get()).texture());
                int tintColor = -1;
                this.itemSoilQuads.put(item, this.getSoilQuadsWithTexture(sprite, 0, tintColor));
            }
            finalQuads.addAll((Collection<BakedQuad>)this.itemSoilQuads.get(item));
        }
        if (extraData.has(BonsaiPotBlock.CAMOUFLAGE)) {
            Block camouflageBlock = (Block)extraData.get(BonsaiPotBlock.CAMOUFLAGE);
            BlockState camouflageState = camouflageBlock.defaultBlockState();
            if (!this.camouflageQuads.containsKey(camouflageBlock)) {
                BakedModel camouflageModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(camouflageState);
                ArrayList<BakedQuad> camouflageQuadsResult = new ArrayList<BakedQuad>();
                for (BlockElement element : this.elements) {
                    for (Direction direction : element.faces.keySet()) {
                        List camouflageQuads = camouflageModel.getQuads(camouflageState, direction, rand, extraData, renderType);
                        if (camouflageQuads.isEmpty()) continue;
                        BakedQuad firstCamouflageQuad = (BakedQuad)camouflageQuads.getFirst();
                        TextureAtlasSprite faceTexture = firstCamouflageQuad.getSprite();
                        BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                        BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)faceTexture, (Direction)direction, (ModelState)new SimpleModelState(new Transformation(null)));
                        camouflageQuadsResult.add(quad);
                    }
                }
                this.camouflageQuads.put(camouflageBlock, camouflageQuadsResult);
            }
            finalQuads.addAll((Collection<BakedQuad>)this.camouflageQuads.get(camouflageBlock));
        } else {
            finalQuads.addAll(quads);
        }
        return finalQuads;
    }

    public ItemTransforms getTransforms() {
        return this.originalModel.getTransforms();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        return TriState.TRUE;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid()});
    }
}

