/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.wormhole;

import com.jinqinxixi.bountifulbaubles.wormhole.PacketHandler;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerSelectionScreen
extends Screen {
    private final List<String> players;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 15;
    private static final int MARGIN = 4;

    public PlayerSelectionScreen(List<String> players) {
        super((Component)Component.translatable((String)"gui.player_selection.title"));
        this.players = players;
    }

    protected void init() {
        super.init();
        int startY = (this.height - this.players.size() * 19) / 2;
        if (startY < 20) {
            startY = 20;
        }
        for (int i = 0; i < this.players.size(); ++i) {
            String playerName = this.players.get(i);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)playerName), button -> this.handleSelection(playerName)).pos((this.width - 80) / 2, startY + i * 19).size(80, 15).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).pos((this.width - 80) / 2, this.height - 30).size(80, 15).build());
    }

    private void handleSelection(String playerName) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.TeleportRequestPayload(playerName), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(gui, mouseX, mouseY, partialTick);
        }
        gui.drawCenteredString(this.font, this.title, this.width / 2 + 1, 11, 0);
        gui.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        super.render(gui, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

