/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.wormhole;

import com.jinqinxixi.bountifulbaubles.items.Baubles.WormholeMirrorItem;
import com.jinqinxixi.bountifulbaubles.items.Potion.WormholePotion;
import com.jinqinxixi.bountifulbaubles.wormhole.ClientHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    private static final String MOD_ID = "bountifulbaubles";
    private static final String PROTOCOL_VERSION = "1.0";
    private static final ResourceLocation PLAYER_LIST_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"player_list");
    private static final ResourceLocation TELEPORT_REQUEST_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"teleport_request");

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID).versioned(PROTOCOL_VERSION).optional();
        registrar.playToClient(PlayerListPayload.TYPE, PlayerListPayload.CODEC, PacketHandler::handlePlayerList);
        registrar.playToServer(TeleportRequestPayload.TYPE, TeleportRequestPayload.CODEC, PacketHandler::handleTeleportRequest);
    }

    private static void handlePlayerList(PlayerListPayload payload, IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> ClientHandler.openPlayerSelection(payload.players()));
        }
    }

    private static void handleTeleportRequest(TeleportRequestPayload payload, IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer player = (ServerPlayer)context.player();
                if (player != null && PacketHandler.isValidRequest(player, payload.targetName())) {
                    PacketHandler.executeTeleportRequest(player, payload.targetName());
                }
            });
        }
    }

    private static Item getUsedWormholeItem(ServerPlayer player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (mainHand.getItem() instanceof WormholeMirrorItem || mainHand.getItem() instanceof WormholePotion) {
            return mainHand.getItem();
        }
        if (offHand.getItem() instanceof WormholeMirrorItem || offHand.getItem() instanceof WormholePotion) {
            return offHand.getItem();
        }
        return null;
    }

    private static boolean isValidRequest(ServerPlayer requester, String targetName) {
        Item usedItem = PacketHandler.getUsedWormholeItem(requester);
        if (usedItem == null) {
            requester.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.invalid_item").withStyle(ChatFormatting.RED));
            return false;
        }
        if (requester.getCooldowns().isOnCooldown(usedItem)) {
            requester.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.cooldown").withStyle(ChatFormatting.YELLOW));
            return false;
        }
        return true;
    }

    private static void executeTeleportRequest(ServerPlayer requester, String targetName) {
        Item usedItem = PacketHandler.getUsedWormholeItem(requester);
        if (usedItem == null) {
            return;
        }
        if (targetName.isEmpty()) {
            PacketHandler.handlePlayerListRequest(requester, usedItem);
            return;
        }
        PacketHandler.handleTeleportExecution(requester, targetName, usedItem);
    }

    private static void handlePlayerListRequest(ServerPlayer requester, Item usedItem) {
        List<String> onlinePlayers = requester.server.getPlayerList().getPlayers().stream().map(p -> p.getGameProfile().getName()).filter(name -> !name.equals(requester.getGameProfile().getName())).toList();
        PacketDistributor.sendToPlayer((ServerPlayer)requester, (CustomPacketPayload)new PlayerListPayload(onlinePlayers), (CustomPacketPayload[])new CustomPacketPayload[0]);
        requester.getCooldowns().addCooldown(usedItem, 2);
    }

    private static void handleTeleportExecution(ServerPlayer requester, String targetName, Item usedItem) {
        ServerPlayer target = requester.server.getPlayerList().getPlayerByName(targetName);
        if (target == null || requester.getUUID().equals(target.getUUID())) {
            PacketHandler.sendErrorMessage(requester, targetName);
            return;
        }
        if (usedItem instanceof WormholeMirrorItem) {
            WormholeMirrorItem mirror = (WormholeMirrorItem)usedItem;
            mirror.teleportToPlayer(requester, targetName);
        } else if (usedItem instanceof WormholePotion) {
            WormholePotion potion = (WormholePotion)usedItem;
            potion.teleportToPlayer(requester, targetName);
        }
    }

    private static void sendErrorMessage(ServerPlayer requester, String targetName) {
        requester.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.target_offline", (Object[])new Object[]{targetName}).withStyle(ChatFormatting.RED));
    }

    public record PlayerListPayload(List<String> players) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerListPayload> TYPE = new CustomPacketPayload.Type(PLAYER_LIST_ID);
        public static final StreamCodec<FriendlyByteBuf, PlayerListPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), PlayerListPayload::players, PlayerListPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record TeleportRequestPayload(String targetName) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<TeleportRequestPayload> TYPE = new CustomPacketPayload.Type(TELEPORT_REQUEST_ID);
        public static final StreamCodec<FriendlyByteBuf, TeleportRequestPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TeleportRequestPayload::targetName, TeleportRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

