/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.recast;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

@EventBusSubscriber
public class AnvilRecastHandler {
    private static final Map<Item, RecastRecipe> RECIPES = new HashMap<Item, RecastRecipe>();

    private static int getExpCost() {
        return ModConfig.getAnvilRecastExpCost();
    }

    private static int getMaterialCost() {
        return ModConfig.getAnvilRecastMaterialCost();
    }

    public static void registerRecipe(Item baseItem, Item tokenItem, Item resultItem) {
        RECIPES.put(baseItem, new RecastRecipe(tokenItem, resultItem));
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        RecastRecipe recipe;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.isEmpty() && !right.isEmpty() && (recipe = RECIPES.get(left.getItem())) != null && recipe.matches(right)) {
            ItemStack output = left.copy();
            CustomData data = (CustomData)output.get(DataComponents.CUSTOM_DATA);
            if (data != null) {
                output.remove(DataComponents.CUSTOM_DATA);
            }
            event.setOutput(output);
            event.setCost((long)AnvilRecastHandler.getExpCost());
            event.setMaterialCost(AnvilRecastHandler.getMaterialCost());
        }
    }

    public static class RecastRecipe {
        private final Item tokenItem;
        private final Item resultItem;

        public RecastRecipe(Item tokenItem, Item resultItem) {
            this.tokenItem = tokenItem;
            this.resultItem = resultItem;
        }

        public boolean matches(ItemStack rightStack) {
            return rightStack.getItem() == this.tokenItem;
        }
    }
}

