/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.network.CoolDownSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class TotemNetworkHandler {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("bountifulbaubles").versioned("1.2");
        registrar.playToClient(CoolDownSyncPacket.TYPE, CoolDownSyncPacket.STREAM_CODEC, (payload, context) -> payload.handle(context));
    }

    public static void sendToPlayer(ServerPlayer player, CoolDownSyncPacket packet) {
        player.connection.send((CustomPacketPayload)packet);
    }

    public static void syncConfigOnLogin(ServerPlayer player) {
        int configDuration;
        CompoundTag data = player.getPersistentData();
        int remaining = data.contains("bountifulbaubles:totem_cooldown") ? data.getInt("bountifulbaubles:totem_cooldown") : -1;
        if (remaining > (configDuration = ModConfig.getTotemCooldown())) {
            remaining = configDuration;
            data.putInt("bountifulbaubles:totem_cooldown", remaining);
        }
        TotemNetworkHandler.sendToPlayer(player, new CoolDownSyncPacket(remaining, configDuration));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TotemNetworkHandler.syncConfigOnLogin(player2);
        }
    }
}

