/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network;

import com.jinqinxixi.bountifulbaubles.items.Baubles.MindsEyeItem;
import java.util.AbstractMap;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MarkTargetPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"mark_target");
    public static final CustomPacketPayload.Type<MarkTargetPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, MarkTargetPacket> STREAM_CODEC = StreamCodec.ofMember(MarkTargetPacket::write, MarkTargetPacket::new);
    private final UUID playerUUID;
    private final int entityId;
    private final long endTime;
    private final boolean shouldClear;
    private final PacketType type;

    public MarkTargetPacket(UUID playerUUID, int entityId, long endTime, boolean shouldClear) {
        this.playerUUID = playerUUID;
        this.entityId = entityId;
        this.endTime = endTime;
        this.shouldClear = shouldClear;
        this.type = shouldClear ? PacketType.CLEAR : PacketType.MARK;
    }

    public MarkTargetPacket(FriendlyByteBuf buf) {
        this.playerUUID = buf.readUUID();
        this.entityId = buf.readInt();
        this.endTime = buf.readLong();
        this.shouldClear = buf.readBoolean();
        this.type = PacketType.values()[buf.readByte()];
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.playerUUID);
        buf.writeInt(this.entityId);
        buf.writeLong(this.endTime);
        buf.writeBoolean(this.shouldClear);
        buf.writeByte(this.type.ordinal());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null && context.player().level().isClientSide()) {
                this.handleClientSide();
            }
        });
    }

    private void handleClientSide() {
        switch (this.type.ordinal()) {
            case 1: {
                MindsEyeItem.getMarkedTargets().remove(this.playerUUID);
                break;
            }
            case 0: 
            case 2: {
                if (this.shouldClear) {
                    MindsEyeItem.getMarkedTargets().remove(this.playerUUID);
                    break;
                }
                MindsEyeItem.getMarkedTargets().put(this.playerUUID, new AbstractMap.SimpleEntry<Integer, Long>(this.entityId, this.endTime));
            }
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isShouldClear() {
        return this.shouldClear;
    }

    public PacketType getPacketType() {
        return this.type;
    }

    public static enum PacketType {
        MARK,
        CLEAR,
        UPDATE;

    }
}

