/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DoubleJumpParticlePacket(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DoubleJumpParticlePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"double_jump_particles"));
    public static final StreamCodec<FriendlyByteBuf, DoubleJumpParticlePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> buf.writeInt(packet.entityId), buf -> new DoubleJumpParticlePacket(buf.readInt()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(DoubleJumpParticlePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientLevel level;
            Entity entity;
            Player player = context.player();
            if (player != null && player.level().isClientSide() && (entity = (level = (ClientLevel)player.level()).getEntity(packet.entityId())) != null) {
                Vec3 pos = entity.position();
                RandomSource random = entity.getRandom();
                for (int i = 0; i < 8; ++i) {
                    double dx = random.nextGaussian() * 0.02;
                    double dy = random.nextGaussian() * 0.02 + 0.2;
                    double dz = random.nextGaussian() * 0.02;
                    level.addParticle((ParticleOptions)ParticleTypes.CLOUD, pos.x + (double)random.nextFloat() * 0.6 - 0.3, pos.y, pos.z + (double)random.nextFloat() * 0.6 - 0.3, dx, dy, dz);
                }
            }
        });
    }
}

