/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CoolDownSyncPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"cooldown_sync");
    public static final CustomPacketPayload.Type<CoolDownSyncPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, CoolDownSyncPacket> STREAM_CODEC = StreamCodec.ofMember(CoolDownSyncPacket::write, CoolDownSyncPacket::new);
    private final int remainingTicks;
    private final int configDuration;

    public CoolDownSyncPacket(int remainingTicks, int configDuration) {
        this.remainingTicks = remainingTicks;
        this.configDuration = configDuration;
    }

    public CoolDownSyncPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt());
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeInt(this.remainingTicks);
        buf.writeInt(this.configDuration);
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                this.updateClientData(player);
            }
        });
    }

    private void updateClientData(LocalPlayer player) {
        ClientConfigCache.setTotemCooldown(this.configDuration);
        CompoundTag data = player.getPersistentData();
        if (this.remainingTicks >= 0) {
            data.putInt("bountifulbaubles:totem_cooldown", this.remainingTicks);
        } else {
            data.remove("bountifulbaubles:totem_cooldown");
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class ClientConfigCache {
        private static int totemCooldown = 200;

        public static void setTotemCooldown(int value) {
            totemCooldown = Math.max(value, 0);
        }

        public static int getTotemCooldown() {
            return totemCooldown;
        }
    }
}

