/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.modifier;

import com.jinqinxixi.bountifulbaubles.BountifulBaublesMod;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class ModifiableBaubleItem
extends Item
implements ICurioItem {
    public static final String INITIALIZED_KEY = "IsInitialized";
    private static final Random RANDOM = new Random();

    public ModifiableBaubleItem(Item.Properties properties) {
        super(properties);
    }

    public abstract Modifier[] getModifiers();

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CustomData data;
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!(!(entity instanceof Player) || stack.isEmpty() || (data = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && data.getUnsafe().getBoolean(INITIALIZED_KEY))) {
            this.initializeModifier(stack);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    protected void initializeModifier(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null || !data.getUnsafe().getBoolean(INITIALIZED_KEY)) {
            Modifier selected = this.getRandomModifier();
            CompoundTag tag = new CompoundTag();
            String uniqueId = selected.id().toString() + "_" + UUID.randomUUID().toString().substring(0, 6);
            tag.putString("ModifierId", uniqueId);
            tag.putString("BaseModifierId", selected.id().toString());
            tag.putString("Attribute", selected.attributeId().toString());
            tag.putString("TranslationKey", selected.translationKey());
            tag.putDouble("Value", selected.value());
            tag.putBoolean(INITIALIZED_KEY, true);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    private Modifier getRandomModifier() {
        Modifier[] modifiers = this.getModifiers();
        return modifiers[RANDOM.nextInt(modifiers.length)];
    }

    public void applyModifier(Player player, ItemStack stack) {
        if (!ModConfig.isModifierEnabled()) {
            return;
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            CompoundTag tag = data.getUnsafe();
            try {
                AttributeModifier.Operation operation;
                double value;
                ResourceLocation modifierId;
                AttributeModifier mod;
                AttributeInstance instance;
                ResourceLocation attributeId = ResourceLocation.parse((String)tag.getString("Attribute"));
                ResourceKey key = ResourceKey.create((ResourceKey)BuiltInRegistries.ATTRIBUTE.key(), (ResourceLocation)attributeId);
                Holder attributeHolder = BuiltInRegistries.ATTRIBUTE.getHolder(key).orElse(null);
                if (attributeHolder != null && (instance = player.getAttribute(attributeHolder)) != null && !instance.hasModifier((mod = new AttributeModifier(modifierId = ResourceLocation.parse((String)tag.getString("ModifierId")), value = tag.getDouble("Value"), operation = this.getOperationType((Holder<Attribute>)attributeHolder))).id())) {
                    instance.addPermanentModifier(mod);
                }
            }
            catch (Exception e) {
                BountifulBaublesMod.LOGGER.error("Apply modifier failed: {}", (Object)e.getMessage());
            }
        }
    }

    protected void removeModifier(Player player, ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            CompoundTag tag = data.getUnsafe();
            try {
                ResourceLocation modifierId = ResourceLocation.parse((String)tag.getString("ModifierId"));
                ResourceLocation attributeId = ResourceLocation.parse((String)tag.getString("Attribute"));
                Holder attributeHolder = BuiltInRegistries.ATTRIBUTE.getHolder(attributeId).orElse(null);
                if (attributeHolder != null) {
                    AttributeInstance instance = player.getAttribute(attributeHolder);
                    if (instance != null) {
                        instance.removeModifier(modifierId);
                    }
                    if (attributeHolder.value() == Attributes.MAX_HEALTH) {
                        player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                    }
                }
            }
            catch (Exception e) {
                BountifulBaublesMod.LOGGER.error("\u79fb\u9664\u4fee\u9970\u7b26\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null && ModConfig.isModifierEnabled()) {
            CompoundTag tag = data.getUnsafe();
            if (tag.contains("TranslationKey") && tag.contains("Value")) {
                String translationKey = tag.getString("TranslationKey");
                double value = tag.getDouble("Value");
                String baseModifierId = tag.getString("BaseModifierId");
                MutableComponent displayName = Component.translatable((String)("modifier." + baseModifierId.replace(':', '.')));
                String formattedValue = value == (double)((int)value) ? String.valueOf((int)value) : (value >= 1.0 ? String.format("%.1f", value) : String.format("%d%%", (int)(value * 100.0)));
                tooltip.add((Component)Component.literal((String)"\u25c6 ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.translatable((String)translationKey)).append((Component)Component.literal((String)(" +" + formattedValue)).withStyle(ChatFormatting.GREEN)));
            }
        } else if (data == null && ModConfig.isModifierEnabled()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.unidentified").withStyle(ChatFormatting.GRAY));
        }
    }

    AttributeModifier.Operation getOperationType(Holder<Attribute> attributeHolder) {
        if (attributeHolder == null) {
            return AttributeModifier.Operation.ADD_VALUE;
        }
        Attribute attribute = (Attribute)attributeHolder.value();
        ResourceLocation attributeId = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        if (attributeId == null) {
            return AttributeModifier.Operation.ADD_VALUE;
        }
        return switch (attributeId.toString()) {
            case "minecraft:generic.attack_speed", "minecraft:generic.movement_speed", "minecraft:generic.attack_damage" -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            default -> AttributeModifier.Operation.ADD_VALUE;
        };
    }

    public static enum Modifier {
        HALF_HEARTED("half_hearted", 1.0, "generic.max_health"),
        HEARTY("hearty", 2.0, "generic.max_health"),
        HARD("hard", 1.0, "generic.armor"),
        GUARDING("guarding", 1.5, "generic.armor"),
        ARMORED("armored", 2.0, "generic.armor"),
        WARDING("warding", 1.0, "generic.armor_toughness"),
        JAGGED("jagged", 0.02, "generic.attack_damage"),
        SPIKED("spiked", 0.04, "generic.attack_damage"),
        ANGRY("angry", 0.06, "generic.attack_damage"),
        MENACING("menacing", 0.08, "generic.attack_damage"),
        BRISK("brisk", 0.01, "generic.movement_speed"),
        FLEETING("fleeting", 0.02, "generic.movement_speed"),
        HASTY("hasty", 0.03, "generic.movement_speed"),
        QUICK("quick", 0.04, "generic.movement_speed"),
        WILD("wild", 0.02, "generic.attack_speed"),
        RASH("rash", 0.04, "generic.attack_speed"),
        INTREPID("intrepid", 0.06, "generic.attack_speed"),
        VIOLENT("violent", 0.08, "generic.attack_speed");

        private final String translationKey;
        private final double value;
        private final String attributePath;
        private final ResourceLocation id;

        private Modifier(String key, double value, String attributePath) {
            this.translationKey = "modifier.bountifulbaubles." + key;
            this.value = value;
            this.attributePath = attributePath;
            this.id = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)key);
        }

        public ResourceLocation attributeId() {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)this.attributePath);
        }

        public Holder<Attribute> attribute() {
            ResourceKey key = ResourceKey.create((ResourceKey)BuiltInRegistries.ATTRIBUTE.key(), (ResourceLocation)this.attributeId());
            return (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(key).orElseThrow(() -> new IllegalStateException("Missing attribute: " + String.valueOf(this.attributeId())));
        }

        public ResourceLocation id() {
            return this.id;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double value() {
            return this.value;
        }
    }
}

