/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.mobeffects;

import com.jinqinxixi.bountifulbaubles.mobeffects.ModEffects;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

public class SinfulEffect
extends MobEffect {
    private static final UUID DAMAGE_UUID = SinfulEffect.createUUID("sinful_damage");
    private static final UUID ARMOR_UUID = SinfulEffect.createUUID("sinful_armor");
    private static final UUID TOUGHNESS_UUID = SinfulEffect.createUUID("sinful_toughness");

    private static UUID createUUID(String path) {
        return UUID.nameUUIDFromBytes(ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)path).toString().getBytes(StandardCharsets.UTF_8));
    }

    public SinfulEffect() {
        super(MobEffectCategory.BENEFICIAL, 0x8B0000);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, SinfulEffect.createResourceLocation("attack_damage"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, amplifier -> {
            int cappedAmplifier = Math.min(amplifier, 3);
            return 0.25 * ((double)cappedAmplifier + 1.0);
        });
        this.addAttributeModifier(Attributes.ARMOR, SinfulEffect.createResourceLocation("armor"), AttributeModifier.Operation.ADD_VALUE, amplifier -> {
            int cappedAmplifier = Math.min(amplifier, 3);
            return 3.0 * ((double)cappedAmplifier + 1.0);
        });
        this.addAttributeModifier(Attributes.ARMOR_TOUGHNESS, SinfulEffect.createResourceLocation("armor_toughness"), AttributeModifier.Operation.ADD_VALUE, amplifier -> {
            int cappedAmplifier = Math.min(amplifier, 3);
            return 1.0 * ((double)cappedAmplifier + 1.0);
        });
    }

    private static ResourceLocation createResourceLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)path);
    }

    public static class ClientEffectHandler {
        public static void registerExtensions(RegisterClientExtensionsEvent event) {
            event.registerMobEffect(new IClientMobEffectExtensions(){

                public boolean isVisibleInGui(MobEffectInstance instance) {
                    return true;
                }
            }, new MobEffect[]{(MobEffect)ModEffects.SINFUL.get()});
        }
    }
}

