/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.loot;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.items.ModItems;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="bountifulbaubles")
public class LootHandler {
    private static final Logger log = LoggerFactory.getLogger(LootHandler.class);

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableId = event.getName();
        List<ModConfig.LootEntry> entries = ModConfig.lootConfig.get(tableId);
        if (entries != null && !entries.isEmpty()) {
            LootPool.Builder poolBuilder = LootPool.lootPool().name("bountifulbaubles_config_loot");
            for (ModConfig.LootEntry entry : entries) {
                Item item = (Item)BuiltInRegistries.ITEM.get(entry.itemId);
                if (item != null) {
                    poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).setWeight(entry.weight)).setRolls((NumberProvider)UniformGenerator.between((float)entry.minRolls, (float)entry.maxRolls));
                    continue;
                }
                log.error("Invalid item in config: {}", (Object)entry.itemId);
            }
            event.getTable().addPool(poolBuilder.build());
            log.debug("Added custom loot to {}", (Object)tableId);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (!(event.getSource().getEntity() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level world = entity.level();
        if (world.isClientSide()) {
            return;
        }
        RandomSource rand = entity.getRandom();
        LootHandler.handleMobDrops(entity, rand, world);
    }

    private static void handleMobDrops(LivingEntity entity, RandomSource rand, Level world) {
        if (entity instanceof Husk) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getHuskAppleChance(), (Item)ModItems.APPLE.get());
        } else if (entity instanceof ElderGuardian) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getElderGuardianVitaminsChance(), (Item)ModItems.VITAMINS.get());
        } else if (entity instanceof Stray) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getStrayRingChance(), (Item)ModItems.RING_OVERCLOCKING.get());
        } else if (entity instanceof Shulker) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getShulkerHeartChance(), (Item)ModItems.SHULKER_HEART.get());
        } else if (entity instanceof CaveSpider) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getCaveSpiderBezoarChance(), (Item)ModItems.BEZOAR.get());
        } else if (entity instanceof EnderDragon) {
            if ((double)rand.nextFloat() < ModConfig.getEnderDragonScaleChance()) {
                LootHandler.handleDragonDrops(entity, rand, world);
            }
        } else if (entity instanceof Evoker) {
            LootHandler.tryDropItem(entity, rand, world, (float)ModConfig.getEvokerTotemChance(), (Item)ModItems.INFINITE_TOTEM.get());
        }
    }

    private static void tryDropItem(LivingEntity entity, RandomSource rand, Level world, float chance, Item item) {
        if (rand.nextFloat() < chance) {
            LootHandler.spawnItem(entity, item, 1, world);
        }
    }

    private static void spawnItem(LivingEntity entity, Item item, int count, Level world) {
        ItemStack stack = new ItemStack((ItemLike)item, count);
        world.addFreshEntity((Entity)new ItemEntity(world, entity.getX(), entity.getY(), entity.getZ(), stack));
    }

    private static void handleDragonDrops(LivingEntity dragon, RandomSource rand, Level world) {
        int minCount = ModConfig.getEnderDragonScaleMinCount();
        int maxCount = ModConfig.getEnderDragonScaleMaxCount();
        int count = minCount + (maxCount > minCount ? rand.nextInt(maxCount - minCount + 1) : 0);
        for (int i = 0; i < count; ++i) {
            ItemEntity item = new ItemEntity(world, dragon.getX(), dragon.getY(), dragon.getZ(), new ItemStack((ItemLike)ModItems.ENDER_DRAGON_SCALE.get()));
            item.setDeltaMovement((rand.nextDouble() - 0.5) * 0.5, rand.nextDouble() * 0.5 + 0.3, (rand.nextDouble() - 0.5) * 0.5);
            world.addFreshEntity((Entity)item);
        }
    }

    private static void trySpawnFromPool(LivingEntity entity, RandomSource rand, Level world, float chance, List<ItemEntry> pool) {
        Item item;
        if (rand.nextFloat() < chance && (item = LootHandler.selectFromPool(pool, rand)) != null) {
            LootHandler.spawnItem(entity, item, 1, world);
        }
    }

    private static Item selectFromPool(List<ItemEntry> pool, RandomSource rand) {
        int totalWeight = pool.stream().mapToInt(e -> e.weight).sum();
        int randomValue = rand.nextInt(totalWeight);
        int cumulative = 0;
        for (ItemEntry entry : pool) {
            if (randomValue >= (cumulative += entry.weight)) continue;
            return entry.item;
        }
        return null;
    }

    private static class ItemEntry {
        final Item item;
        final int weight;

        ItemEntry(Item item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

