/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Potion;

import com.jinqinxixi.bountifulbaubles.items.Baubles.WormholeMirrorItem;
import com.jinqinxixi.bountifulbaubles.wormhole.PacketHandler;
import com.jinqinxixi.bountifulbaubles.wormhole.TeleportRequestManager;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

public class WormholePotion
extends WormholeMirrorItem {
    static final int USE_DURATION = 32;
    private static final float PARTICLE_RADIUS = 1.0f;
    private static final Vector3f CHARGE_COLOR = new Vector3f(0.9f, 0.1f, 1.0f);

    public WormholePotion() {
        super(new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().fast().nutrition(0).alwaysEdible().saturationModifier(0.0f).build()).craftRemainder(Items.GLASS_BOTTLE).rarity(Rarity.UNCOMMON).fireResistant());
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public int getEnchantmentValue() {
        return 0;
    }

    @Override
    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.spawnActivationParticles(serverPlayer, 0.5f);
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float progress = 1.0f - (float)remainingTicks / 32.0f;
            this.spawnChargeParticles(player, progress);
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level.isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.TeleportRequestPayload(""), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.spawnCompletionParticles(serverPlayer);
            }
            player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
        }
        return stack;
    }

    private void spawnActivationParticles(ServerPlayer player, float scale) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y, pos.z, 300, (double)(1.0f * scale), 0.2 * (double)scale, (double)(1.0f * scale), 0.1);
    }

    private void spawnChargeParticles(ServerPlayer player, float progress) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 lookVec = player.getLookAngle().scale(0.5);
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight() - 0.2, 0.0).add(lookVec);
        serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(CHARGE_COLOR, 0.5f), pos.x, pos.y, pos.z, 4, 0.1, 0.1, 0.1, 0.0);
    }

    private void spawnCompletionParticles(ServerPlayer player) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pos.x, pos.y, pos.z, 300, 1.0, 1.0, 1.0, 0.3);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y + 1.0, pos.z, 500, 0.8, 0.8, 0.8, 1.0);
    }

    @Override
    protected void teleportToSpawn(ServerPlayer player) {
    }

    @Override
    public void teleportToPlayer(ServerPlayer sender, String targetName) {
        boolean isMainHand;
        if (sender.getGameProfile().getName().equalsIgnoreCase(targetName)) {
            sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.self_teleport"));
            return;
        }
        ServerPlayer target = sender.server.getPlayerList().getPlayerByName(targetName);
        if (target == null) {
            sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.player_offline", (Object[])new Object[]{targetName}));
            return;
        }
        if (!this.checkCooldown((Player)sender)) {
            return;
        }
        ItemStack stack = sender.getMainHandItem();
        boolean bl = isMainHand = stack.getItem() == this;
        if (!isMainHand && (stack = sender.getOffhandItem()).getItem() != this) {
            return;
        }
        UUID requestId = TeleportRequestManager.addRequest(sender, target);
        Component message = this.createClickableMessage(sender, target, requestId);
        target.sendSystemMessage(message);
        sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.request_sent", (Object[])new Object[]{targetName}));
        if (!sender.getAbilities().instabuild) {
            ItemStack bottleStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            if (stack.getCount() == 1) {
                if (isMainHand) {
                    sender.setItemInHand(InteractionHand.MAIN_HAND, bottleStack);
                } else {
                    sender.setItemInHand(InteractionHand.OFF_HAND, bottleStack);
                }
            } else {
                stack.shrink(1);
                if (!sender.getInventory().add(bottleStack)) {
                    sender.drop(bottleStack, false);
                }
            }
        }
        this.setCooldown((Player)sender);
    }

    @Override
    public void setCooldown(Player player) {
        player.getCooldowns().addCooldown((Item)this, 0);
    }
}

