/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Potion;

import com.jinqinxixi.bountifulbaubles.items.Baubles.MagicMirrorItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecallPotion
extends MagicMirrorItem {
    static final int USE_DURATION = 32;
    private static final int COOLDOWN_TICKS = 5;

    public RecallPotion() {
        super(new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().fast().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()).craftRemainder(Items.GLASS_BOTTLE).rarity(Rarity.UNCOMMON).fireResistant());
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            super.teleportToSpawn(player);
            player.getCooldowns().addCooldown((Item)this, 5);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            player.playSound(SoundEvents.GLASS_BREAK, 0.8f, 1.0f);
        }
        return stack;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public int getEnchantmentValue() {
        return 0;
    }

    @Override
    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

