/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.mobeffects.ModEffects;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class WrathPendantItem
extends ModifiableBaubleItem {
    private static final ResourceLocation DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"wrath_damage");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public WrathPendantItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity != null) {
            entity.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(DAMAGE_ID);
            AttributeModifier modifier = new AttributeModifier(DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE);
            entity.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(modifier);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity != null) {
            entity.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(DAMAGE_ID);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(LivingDamageEvent.Pre event) {
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && WrathPendantItem.isEquipped((LivingEntity)(player = (Player)entity)) && WrathPendantItem.isCriticalHit(player)) {
            WrathPendantItem.applySinfulEffect(player);
        }
    }

    private static boolean isCriticalHit(Player player) {
        return player.fallDistance > 0.0f && !player.onGround() && !player.isInWater() && !player.onClimbable() && !player.isShiftKeyDown();
    }

    private static void applySinfulEffect(Player player) {
        player.addEffect(new MobEffectInstance(ModEffects.SINFUL, ModConfig.getWrathPendantEffectDuration(), ModConfig.getWrathPendantEffectLevel(), false, true, true));
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof WrathPendantItem)).isPresent();
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.wrath_pendant.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.wrath_pendant.effect1").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

