/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.wormhole.PacketHandler;
import com.jinqinxixi.bountifulbaubles.wormhole.TeleportRequestManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

public class WormholeMirrorItem
extends Item {
    private static final int COOLDOWN_TICKS = 10;
    static final int USE_DURATION = 20;
    private static final float PARTICLE_RADIUS = 1.0f;

    public WormholeMirrorItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float progress = 1.0f - (float)remainingTicks / 20.0f;
            this.spawnProgressParticles(player, progress);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.spawnParticles(serverPlayer, 0.5f);
        }
        if (player.isShiftKeyDown()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (this.canTeleport(player)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            ServerPlayer serverPlayer;
            Player player = (Player)entity;
            if (!level.isClientSide && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                this.spawnCompletionParticles(serverPlayer);
            }
            if (player.isShiftKeyDown()) {
                if (level.isClientSide) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.TeleportRequestPayload(""), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
            } else if (!level.isClientSide && player instanceof ServerPlayer && this.checkCooldown((Player)(serverPlayer = (ServerPlayer)player))) {
                this.teleportToSpawn(serverPlayer);
                this.setCooldown((Player)serverPlayer);
            }
        }
        return stack;
    }

    public void teleportToPlayer(ServerPlayer sender, String targetName) {
        if (sender.getGameProfile().getName().equalsIgnoreCase(targetName)) {
            sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.self_teleport"));
            return;
        }
        ServerPlayer target = sender.server.getPlayerList().getPlayerByName(targetName);
        if (target == null) {
            sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.player_offline", (Object[])new Object[]{targetName}));
            return;
        }
        if (!this.checkCooldown((Player)sender)) {
            return;
        }
        UUID requestId = TeleportRequestManager.addRequest(sender, target);
        Component message = this.createClickableMessage(sender, target, requestId);
        target.sendSystemMessage(message);
        sender.sendSystemMessage((Component)Component.translatable((String)"msg.mirror.request_sent", (Object[])new Object[]{targetName}));
        this.setCooldown((Player)sender);
    }

    protected Component createClickableMessage(ServerPlayer requester, ServerPlayer target, UUID requestId) {
        String requesterName = requester.getScoreboardName();
        Component acceptBtn = this.createAcceptButton(requestId);
        Component denyBtn = this.createDenyButton(requestId);
        return Component.translatable((String)"msg.mirror.request_received", (Object[])new Object[]{requesterName}).append(" ").append(acceptBtn).append(" ").append(denyBtn);
    }

    protected Component createAcceptButton(UUID requestId) {
        return Component.literal((String)"[\u2714]").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bountiful tp_accept " + String.valueOf(requestId))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.tp_request.accepted"))));
    }

    protected Component createDenyButton(UUID requestId) {
        return Component.literal((String)"[\u2716]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bountiful tp_deny " + String.valueOf(requestId))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.tp_request.denied"))));
    }

    private boolean canTeleport(Player player) {
        return !player.getCooldowns().isOnCooldown((Item)this);
    }

    protected boolean checkCooldown(Player player) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.magic_mirror.cooldown"));
            }
            return false;
        }
        return true;
    }

    public void playTeleportEffects(ServerPlayer player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY(), player.getZ(), 500, 0.5, 0.5, 0.5, 1.0);
    }

    protected void teleportToSpawn(ServerPlayer player) {
        ServerLevel targetLevel = player.server.getLevel(player.getRespawnDimension());
        BlockPos spawnPos = player.getRespawnPosition();
        float angle = player.getRespawnAngle();
        if (spawnPos == null || targetLevel == null) {
            targetLevel = player.server.overworld();
            spawnPos = targetLevel.getSharedSpawnPos();
        }
        player.teleportTo(targetLevel, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, angle, 0.0f);
        player.fallDistance = 0.0f;
        this.playTeleportEffects(player);
    }

    public void setCooldown(Player player) {
        player.getCooldowns().addCooldown((Item)this, 10);
    }

    private void spawnParticles(ServerPlayer player, float scale) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y, pos.z, 300, (double)(1.0f * scale), 0.2 * (double)scale, (double)(1.0f * scale), 0.1);
    }

    private void spawnProgressParticles(ServerPlayer player, float progress) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 lookVec = player.getLookAngle().scale(0.5);
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight() - 0.2, 0.0).add(lookVec);
        Vector3f purpleColor = new Vector3f(0.9f, 0.1f, 1.0f);
        float particleSize = 0.5f;
        serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(purpleColor, particleSize), pos.x, pos.y, pos.z, 4, 0.1, 0.1, 0.1, 0.0);
    }

    private void spawnCompletionParticles(ServerPlayer player) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pos.x, pos.y, pos.z, 300, 1.0, 1.0, 1.0, 0.3);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.wormhole_mirror.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.wormhole_mirror.effect1").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.wormhole_mirror.description").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

