/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.BountifulBaublesMod;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class TreasureBagItem
extends Item {
    private static final Random RANDOM = new Random();
    private static List<WeightedItem> possibleItems = null;

    public TreasureBagItem(Item.Properties properties) {
        super(properties);
    }

    private void initPossibleItems() {
        if (possibleItems == null) {
            possibleItems = new ArrayList<WeightedItem>();
            try {
                String[] configItems;
                for (String entry : configItems = ModConfig.getTreasureBagItems().split(";")) {
                    try {
                        String[] parts = entry.trim().split(",");
                        if (parts.length != 2) {
                            BountifulBaublesMod.LOGGER.error("Invalid format in treasure bag config: " + entry);
                            continue;
                        }
                        String itemId = parts[0].trim();
                        int weight = Integer.parseInt(parts[1].trim());
                        ResourceLocation resourceLocation = ResourceLocation.parse((String)itemId);
                        Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
                        if (item != null) {
                            possibleItems.add(new WeightedItem((DeferredHolder<Item, ? extends Item>)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation), weight));
                            continue;
                        }
                        BountifulBaublesMod.LOGGER.error("Item not found in registry: " + itemId);
                    }
                    catch (NumberFormatException e) {
                        BountifulBaublesMod.LOGGER.error("Invalid weight in treasure bag config: " + entry);
                    }
                    catch (Exception e) {
                        BountifulBaublesMod.LOGGER.error("Invalid item entry in treasure bag config: " + entry);
                    }
                }
            }
            catch (Exception e) {
                BountifulBaublesMod.LOGGER.error("Error loading treasure bag config", (Throwable)e);
            }
        }
    }

    private DeferredHolder<Item, ? extends Item> getRandomItem() {
        if (possibleItems == null || possibleItems.isEmpty()) {
            return null;
        }
        int totalWeight = possibleItems.stream().mapToInt(item -> item.weight).sum();
        int randomWeight = RANDOM.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedItem weightedItem : possibleItems) {
            if (randomWeight >= (currentWeight += weightedItem.weight)) continue;
            return weightedItem.item;
        }
        return TreasureBagItem.possibleItems.get((int)(TreasureBagItem.possibleItems.size() - 1)).item;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            this.initPossibleItems();
            if (possibleItems != null && !possibleItems.isEmpty()) {
                DeferredHolder<Item, ? extends Item> randomItem = this.getRandomItem();
                if (randomItem != null) {
                    ItemStack rewardStack = new ItemStack((ItemLike)randomItem.get());
                    if (!player.getInventory().add(rewardStack)) {
                        player.drop(rewardStack, false);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.5f, 1.0f);
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                }
            } else {
                BountifulBaublesMod.LOGGER.error("Treasure bag has no possible items configured!");
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.treasure_bag").withStyle(ChatFormatting.BLUE));
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private static class WeightedItem {
        final DeferredHolder<Item, ? extends Item> item;
        final int weight;

        WeightedItem(DeferredHolder<Item, ? extends Item> item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

