/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ThaSpiderItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ThaSpiderItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        boolean hasSpiderRing = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof ThaSpiderItem)).isPresent();
        if (hasSpiderRing) {
            ThaSpiderItem.handleWallClimb(player);
        }
    }

    private static void handleWallClimb(Player player) {
        if (!player.onGround() && !player.isInWater() && !player.isInLava() && player.zza > 0.0f) {
            if (ThaSpiderItem.isPlayerTouchingWall(player)) {
                Vec3 motion = player.getDeltaMovement();
                if (player.isShiftKeyDown()) {
                    player.setDeltaMovement(motion.x, 0.0, motion.z);
                } else {
                    double upwardSpeed = 0.11;
                    player.setDeltaMovement(motion.x, upwardSpeed, motion.z);
                }
                player.resetFallDistance();
                double drag = 0.7;
                player.setDeltaMovement(player.getDeltaMovement().multiply(drag, 1.0, drag));
            }
        } else if (ThaSpiderItem.isPlayerTouchingWall(player) && player.isShiftKeyDown()) {
            player.setDeltaMovement(player.getDeltaMovement().multiply(0.7, 0.0, 0.7));
            player.resetFallDistance();
        }
    }

    private static boolean isPlayerTouchingWall(Player player) {
        AABB boundingBox = player.getBoundingBox();
        AABB checkBox = boundingBox.inflate(0.15, 0.0, 0.15);
        Level level = player.level();
        double[] checkPoints = new double[]{player.getX() - 0.35, player.getX() + 0.35, player.getZ() - 0.35, player.getZ() + 0.35};
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = (int)Math.floor(boundingBox.minY);
        int maxY = (int)Math.ceil(boundingBox.maxY);
        for (int y = minY; y <= maxY; ++y) {
            pos.set(checkPoints[0], (double)y, player.getZ());
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.set(checkPoints[1], (double)y, player.getZ());
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.set(player.getX(), (double)y, checkPoints[2]);
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.set(player.getX(), (double)y, checkPoints[3]);
            if (!ThaSpiderItem.isValidWall(level, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidWall(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.isAir() && blockState.isSolid() && !(blockState.getBlock() instanceof LadderBlock) && !(blockState.getBlock() instanceof VineBlock)) {
            VoxelShape shape = blockState.getCollisionShape((BlockGetter)level, pos);
            return !shape.isEmpty();
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.tha_spider.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

