/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class StarfishItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public StarfishItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player attacker;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player victim = (Player)livingEntity;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && StarfishItem.shouldPreventAttack(attacker = (Player)entity, victim)) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerAttack(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Entity attacker;
            Player victim = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Player && StarfishItem.shouldPreventAttack((Player)(attacker = entity), victim)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean shouldPreventAttack(Player attacker, Player victim) {
        boolean victimHasStarfish = CuriosApi.getCuriosInventory((LivingEntity)victim).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof StarfishItem)).isPresent();
        boolean attackerHasStarfish = CuriosApi.getCuriosInventory((LivingEntity)attacker).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof StarfishItem)).isPresent();
        return victimHasStarfish && attackerHasStarfish;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.starfish.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }
}

