/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@EventBusSubscriber(modid="bountifulbaubles")
public class RubyHeartItem
extends ModifiableBaubleItem
implements ICurio {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public RubyHeartItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public ItemStack getStack() {
        return this.getDefaultInstance();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof RubyHeartItem)).ifPresent(slotResult -> RubyHeartItem.handleDamageProtection(event, player, slotResult.stack()));
    }

    private static void handleDamageProtection(LivingDamageEvent.Pre event, Player player, ItemStack rubyHeart) {
        float currentHealthPercent = player.getHealth() / player.getMaxHealth();
        if ((double)currentHealthPercent <= ModConfig.getRubyHeartHealthThreshold()) {
            return;
        }
        if (player.getCooldowns().isOnCooldown(rubyHeart.getItem())) {
            return;
        }
        float damageAmount = event.getContainer().getNewDamage();
        float healthAfterDamage = player.getHealth() - damageAmount;
        if (healthAfterDamage <= 0.0f) {
            event.getContainer().setNewDamage(0.0f);
            player.setHealth(1.0f);
            player.getCooldowns().addCooldown(rubyHeart.getItem(), ModConfig.getRubyHeartCooldown() * 20);
            player.displayClientMessage((Component)Component.translatable((String)"message.bountifulbaubles.ruby_heart.activated").withStyle(ChatFormatting.RED), true);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ruby_heart.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ruby_heart.threshold", (Object[])new Object[]{String.format("%.0f", ModConfig.getRubyHeartHealthThreshold() * 100.0)}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ruby_heart.cooldown", (Object[])new Object[]{ModConfig.getRubyHeartCooldown()}).withStyle(ChatFormatting.DARK_GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }
}

