/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@EventBusSubscriber(modid="bountifulbaubles")
public class RockCandyItem
extends ModifiableBaubleItem
implements ICurio {
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"rock_candy_speed_boost");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public RockCandyItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public ItemStack getStack() {
        return this.getDefaultInstance();
    }

    private boolean hasSpeedModifier(Player player) {
        return player.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(SPEED_MODIFIER_ID) != null;
    }

    private boolean hasOtherRockCandy(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findCurios(item -> item.getItem() instanceof RockCandyItem).size() > 0).orElse(false);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
            if (!this.hasSpeedModifier(player)) {
                player.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(new AttributeModifier(SPEED_MODIFIER_ID, ModConfig.getRockCandySpeedMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
            boolean hasOtherRockCandy = this.hasOtherRockCandy(player);
            if (!hasOtherRockCandy) {
                player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_ID);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof RockCandyItem)).ifPresent(slotResult -> {
            float newDamage = event.getNewDamage() * (float)ModConfig.getRockCandyDamageMultiplier();
            event.setNewDamage(newDamage);
        });
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.rock_candy.speed_boost", (Object[])new Object[]{String.format("%.0f", ModConfig.getRockCandySpeedMultiplier() * 100.0)}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.rock_candy.damage_warning", (Object[])new Object[]{String.format("%.1f", ModConfig.getRockCandyDamageMultiplier())}).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.rock_candy.no_stack").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }
}

