/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class RingOverclockingItem
extends ModifiableBaubleItem {
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"overclocking_speed");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, 0.07, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final Holder<MobEffect>[] RING_OVERCLOCKING_EFFECTS = new Holder[]{MobEffects.MOVEMENT_SLOWDOWN};
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public RingOverclockingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        for (Holder<MobEffect> effect : RING_OVERCLOCKING_EFFECTS) {
            entity.removeEffect(effect);
        }
        AttributeInstance speedAttr = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttr != null && !speedAttr.hasModifier(SPEED_MODIFIER_ID)) {
            speedAttr.addPermanentModifier(SPEED_MODIFIER);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        boolean hasOtherRings;
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        boolean bl = hasOtherRings = CuriosApi.getCuriosInventory((LivingEntity)entity).map(handler -> handler.findCurios(itemStack -> itemStack.getItem() instanceof RingOverclockingItem)).orElse(Collections.emptyList()).size() > 0;
        if (hasOtherRings) {
            return;
        }
        AttributeInstance speedAttr = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttr != null) {
            speedAttr.removeModifier(SPEED_MODIFIER_ID);
        }
    }

    @SubscribeEvent
    public static void onEffectApplicable(MobEffectEvent.Applicable event) {
        Holder effectHolder = event.getEffectInstance().getEffect();
        if (RingOverclockingItem.shouldBlockEffect(event.getEntity(), (Holder<MobEffect>)effectHolder)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private static boolean shouldBlockEffect(LivingEntity entity, Holder<MobEffect> effectHolder) {
        for (Holder<MobEffect> target : RING_OVERCLOCKING_EFFECTS) {
            if (effectHolder != target) continue;
            return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof RingOverclockingItem)).isPresent();
        }
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ring_overclocking.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ring_overclocking.description").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

