/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class ObsidianSkullItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ObsidianSkullItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFireDamage(LivingDamageEvent.Pre event) {
        boolean hasSkull;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (ObsidianSkullItem.isFireDamage(source) && !ObsidianSkullItem.isLavaDamage(source) && (hasSkull = CuriosApi.getCuriosInventory((LivingEntity)entity).map(handler -> handler.findFirstCurio(item -> item.getItem() instanceof ObsidianSkullItem).isPresent()).orElse(false).booleanValue())) {
            event.setNewDamage(event.getNewDamage() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide()) {
            ObsidianSkullItem.handleFireProtection(living);
        }
    }

    private static void handleFireProtection(LivingEntity entity) {
        boolean hasSkull;
        if (entity.getRemainingFireTicks() > 0 && (hasSkull = CuriosApi.getCuriosInventory((LivingEntity)entity).map(handler -> handler.findFirstCurio(item -> item.getItem() instanceof ObsidianSkullItem).isPresent()).orElse(false).booleanValue())) {
            entity.setRemainingFireTicks(0);
            entity.clearFire();
        }
    }

    private static boolean isLavaDamage(DamageSource source) {
        return source.is(DamageTypes.LAVA) || source.is(DamageTypes.HOT_FLOOR);
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.FIREBALL) || source.is(DamageTypes.UNATTRIBUTED_FIREBALL);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.obsidian_skull.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.obsidian_skull.description").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

