/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@EventBusSubscriber(modid="bountifulbaubles")
public class ObsidianShieldItem
extends ModifiableBaubleItem
implements ICurioItem,
Equipable {
    private static final String MODIFIER_KEY = "KBResistanceID";
    private static final ResourceLocation BASE_ID = ResourceLocation.fromNamespaceAndPath((String)"bountifulbaubles", (String)"knockback_resistance");
    private static final double RESISTANCE_VALUE = 1.0;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ObsidianShieldItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.handleKnockbackResistance(player, stack);
        }
    }

    private void handleKnockbackResistance(Player player, ItemStack stack) {
        ResourceLocation modifierId;
        boolean shouldApply = this.isEquipped(player, stack);
        AttributeInstance attribute = player.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (attribute == null) {
            return;
        }
        ResourceLocation resourceLocation = modifierId = shouldApply ? this.getOrCreateModifierId(stack) : this.getModifierId(stack);
        if (modifierId != null) {
            if (shouldApply && !attribute.hasModifier(modifierId)) {
                attribute.addPermanentModifier(this.createModifier(modifierId));
            } else if (!shouldApply) {
                attribute.removeModifier(modifierId);
            }
        }
    }

    private boolean isEquipped(Player player, ItemStack stack) {
        return this.isHeldInHand(player, stack) || this.isInCurioSlot(player, stack);
    }

    private boolean isHeldInHand(Player player, ItemStack stack) {
        return ItemStack.isSameItem((ItemStack)player.getMainHandItem(), (ItemStack)stack) || ItemStack.isSameItem((ItemStack)player.getOffhandItem(), (ItemStack)stack);
    }

    private boolean isInCurioSlot(Player player, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> ItemStack.isSameItem((ItemStack)item, (ItemStack)stack))).isPresent();
    }

    private AttributeModifier createModifier(ResourceLocation id) {
        return new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_VALUE);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity living = livingEntity;
            this.applyAttribute(living, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity living = livingEntity;
            this.removeAttribute(living, stack);
        }
    }

    private void applyAttribute(LivingEntity entity, ItemStack stack) {
        if (!entity.level().isClientSide()) {
            AttributeInstance attribute = entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            ResourceLocation modifierId = this.getOrCreateModifierId(stack);
            if (attribute != null && !attribute.hasModifier(modifierId)) {
                attribute.addPermanentModifier(this.createModifier(modifierId));
            }
        }
    }

    private void removeAttribute(LivingEntity entity, ItemStack stack) {
        if (!entity.level().isClientSide()) {
            ResourceLocation modifierId = this.getModifierId(stack);
            AttributeInstance attribute = entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (modifierId != null && attribute != null) {
                attribute.removeModifier(modifierId);
            }
        }
    }

    private ResourceLocation getOrCreateModifierId(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains(MODIFIER_KEY)) {
            String uniqueSuffix = UUID.randomUUID().toString().replace("-", "_");
            ResourceLocation uniqueId = ResourceLocation.fromNamespaceAndPath((String)BASE_ID.getNamespace(), (String)(BASE_ID.getPath() + "_" + uniqueSuffix));
            tag.putString(MODIFIER_KEY, uniqueId.toString());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return ResourceLocation.parse((String)tag.getString(MODIFIER_KEY));
    }

    @Nullable
    private ResourceLocation getModifierId(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return data != null && data.getUnsafe().contains(MODIFIER_KEY) ? ResourceLocation.parse((String)data.getUnsafe().getString(MODIFIER_KEY)) : null;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.IRON_INGOT);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public String getDescriptionId(ItemStack stack) {
        DyeColor dyecolor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
        return dyecolor != null ? this.getDescriptionId() + "." + dyecolor.getName() : super.getDescriptionId(stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.OFFHAND;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SHIELD_ACTIONS.contains(itemAbility);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFireDamage(LivingDamageEvent.Pre event) {
        boolean hasShield;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (ObsidianShieldItem.isFireDamage(source) && !ObsidianShieldItem.isLavaDamage(source) && (hasShield = ObsidianShieldItem.isEquippedOrHeld(entity))) {
            event.setNewDamage(event.getNewDamage() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide()) {
            ObsidianShieldItem.handleFireProtection(living);
        }
    }

    private static void handleFireProtection(LivingEntity entity) {
        boolean hasShield;
        if (entity.getRemainingFireTicks() > 0 && (hasShield = ObsidianShieldItem.isEquippedOrHeld(entity))) {
            entity.setRemainingFireTicks(0);
            entity.clearFire();
        }
    }

    private static boolean isLavaDamage(DamageSource source) {
        return source.is(DamageTypes.LAVA) || source.is(DamageTypes.HOT_FLOOR);
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.FIREBALL) || source.is(DamageTypes.UNATTRIBUTED_FIREBALL);
    }

    private static boolean isEquippedOrHeld(LivingEntity entity) {
        if (entity instanceof Player) {
            boolean isHeld;
            Player player = (Player)entity;
            boolean bl = isHeld = player.getMainHandItem().getItem() instanceof ObsidianShieldItem || player.getOffhandItem().getItem() instanceof ObsidianShieldItem;
            if (isHeld) {
                return true;
            }
        }
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof ObsidianShieldItem)).isPresent();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.obsidian_shield.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

