/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class MossyRingItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public MossyRingItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).level().isClientSide()) {
            int timer = 0;
            if (stack.has(ModComponents.REPAIR_TIMER)) {
                timer = (Integer)stack.get(ModComponents.REPAIR_TIMER);
            }
            if (timer >= ModConfig.getMossyRingRepairInterval()) {
                if (this.repairItem(player)) {
                    stack.set(ModComponents.REPAIR_TIMER, (Object)0);
                } else {
                    stack.set(ModComponents.REPAIR_TIMER, (Object)(++timer));
                }
            } else {
                stack.set(ModComponents.REPAIR_TIMER, (Object)(timer + 1));
            }
        }
    }

    private boolean repairItem(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.canRepair(mainHand)) {
            this.repairSingleItem(mainHand, player);
            return true;
        }
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (this.canRepair(offHand)) {
            this.repairSingleItem(offHand, player);
            return true;
        }
        return false;
    }

    private boolean canRepair(ItemStack stack) {
        return !stack.isEmpty() && stack.isDamaged() && stack.getItem().isDamageable(stack);
    }

    private void repairSingleItem(ItemStack stack, Player player) {
        int repairAmount = Math.min(ModConfig.getMossyRingRepairAmount(), stack.getDamageValue());
        stack.setDamageValue(stack.getDamageValue() - repairAmount);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.mossyring.effects", (Object[])new Object[]{Float.valueOf((float)ModConfig.getMossyRingRepairInterval() / 20.0f), ModConfig.getMossyRingRepairAmount()}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.mossyring.description").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

