/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class MossyBeltItem
extends ModifiableBaubleItem {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public MossyBeltItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).level().isClientSide()) {
            int timer = 0;
            if (stack.has(ModComponents.REPAIR_TIMER)) {
                timer = (Integer)stack.get(ModComponents.REPAIR_TIMER);
            }
            if (timer >= ModConfig.getMossyBeltRepairInterval()) {
                if (this.repairArmor(player)) {
                    stack.set(ModComponents.REPAIR_TIMER, (Object)0);
                }
            } else {
                stack.set(ModComponents.REPAIR_TIMER, (Object)(timer + 1));
            }
        }
    }

    private boolean repairArmor(Player player) {
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack armorStack = player.getItemBySlot(slot);
            if (this.canRepair(armorStack)) {
                this.repairSingleItem(armorStack);
                return true;
            }
            if (!(armorStack.getItem() instanceof ArmorItem) || !armorStack.isDamaged()) continue;
            return false;
        }
        return false;
    }

    private boolean canRepair(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof ArmorItem && stack.isDamaged() && stack.getItem().isDamageable(stack);
    }

    private void repairSingleItem(ItemStack stack) {
        int repairAmount = Math.min(ModConfig.getMossyBeltRepairAmount(), stack.getDamageValue());
        stack.setDamageValue(stack.getDamageValue() - repairAmount);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.mossybelt.effects", (Object[])new Object[]{Float.valueOf((float)ModConfig.getMossyBeltRepairInterval() / 20.0f), ModConfig.getMossyBeltRepairAmount()}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.mossybelt.description").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

