/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.bountifulbaubles.network.MarkTargetPacket;
import com.jinqinxixi.bountifulbaubles.network.NetworkHandler;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class MindsEyeItem
extends ModifiableBaubleItem {
    private static final Map<UUID, Map.Entry<Integer, Long>> MARKED_TARGETS = new HashMap<UUID, Map.Entry<Integer, Long>>();
    private static final Map<UUID, Boolean> SHOULD_REMARK = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> SCAN_COOLDOWNS = new HashMap<UUID, Long>();
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public static Map<UUID, Map.Entry<Integer, Long>> getMarkedTargets() {
        return MARKED_TARGETS;
    }

    public MindsEyeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MindsEyeItem.clearMarkedTarget(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        UUID playerUUID = player.getUUID();
        Optional maybeCurios = CuriosApi.getCuriosInventory((LivingEntity)player);
        boolean hasGoggles = maybeCurios.map(curiosInventory -> curiosInventory.findFirstCurio(item -> item.getItem() instanceof MindsEyeItem).isPresent()).orElse(false);
        if (!hasGoggles) {
            MindsEyeItem.clearMarkedTarget(player);
            SHOULD_REMARK.remove(playerUUID);
            return;
        }
        long currentTime = player.level().getGameTime();
        if (SHOULD_REMARK.getOrDefault(playerUUID, false).booleanValue()) {
            MindsEyeItem.scanAndMarkTarget(player);
            SHOULD_REMARK.put(playerUUID, false);
            return;
        }
        long nextScanTime = SCAN_COOLDOWNS.getOrDefault(playerUUID, 0L);
        if (currentTime >= nextScanTime) {
            MindsEyeItem.scanAndMarkTarget(player);
            SCAN_COOLDOWNS.put(playerUUID, currentTime + (long)ModConfig.getTacticalScanInterval());
        }
        MindsEyeItem.updateMarkedTargets(player);
    }

    private static void scanAndMarkTarget(Player player) {
        List nearbyMobs = player.level().getEntitiesOfClass(Mob.class, new AABB(player.position().subtract(ModConfig.getTacticalScanRadius(), ModConfig.getTacticalDownRange(), ModConfig.getTacticalScanRadius()), player.position().add(ModConfig.getTacticalScanRadius(), ModConfig.getTacticalUpRange(), ModConfig.getTacticalScanRadius())), mob -> {
            double dz;
            if (!mob.isAlive() || mob.isInvisible()) {
                return false;
            }
            boolean isHostile = mob instanceof Enemy;
            if (!isHostile) {
                return false;
            }
            if (MARKED_TARGETS.containsKey(player.getUUID()) && MARKED_TARGETS.get(player.getUUID()).getKey().intValue() == mob.getId()) {
                return false;
            }
            double dx = mob.getX() - player.getX();
            double horizontalDistSqr = dx * dx + (dz = mob.getZ() - player.getZ()) * dz;
            if (horizontalDistSqr > ModConfig.getTacticalScanRadius() * ModConfig.getTacticalScanRadius()) {
                return false;
            }
            return player.level().clip(new ClipContext(player.getEyePosition(), mob.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
        });
        if (!nearbyMobs.isEmpty()) {
            MindsEyeItem.clearMarkedTarget(player);
            Mob target = (Mob)nearbyMobs.get(player.getRandom().nextInt(nearbyMobs.size()));
            long endTime = player.level().getGameTime() + (long)ModConfig.getTacticalMarkDuration();
            MARKED_TARGETS.put(player.getUUID(), new AbstractMap.SimpleEntry<Integer, Long>(target.getId(), endTime));
            MindsEyeItem.sendMarkPacket(player, target.getId(), endTime);
            player.level().playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 1.0f, 2.0f);
        } else if (SHOULD_REMARK.getOrDefault(player.getUUID(), false).booleanValue()) {
            SHOULD_REMARK.put(player.getUUID(), false);
            SCAN_COOLDOWNS.put(player.getUUID(), player.level().getGameTime() + (long)ModConfig.getTacticalScanInterval());
        }
    }

    private static void updateMarkedTargets(Player player) {
        Map.Entry<Integer, Long> targetInfo = MARKED_TARGETS.get(player.getUUID());
        if (targetInfo != null && player.level().getGameTime() > targetInfo.getValue()) {
            MindsEyeItem.clearMarkedTarget(player);
        }
    }

    private static void clearMarkedTarget(Player player) {
        UUID playerUUID = player.getUUID();
        Map.Entry<Integer, Long> targetInfo = MARKED_TARGETS.get(playerUUID);
        if (targetInfo != null) {
            MARKED_TARGETS.remove(playerUUID);
            SHOULD_REMARK.remove(playerUUID);
            if (!player.level().isClientSide) {
                NetworkHandler.broadcastToAll(new MarkTargetPacket(playerUUID, targetInfo.getKey(), 0L, true), player.level());
            }
        }
    }

    private static void sendMarkPacket(Player player, int entityId, long endTime) {
        if (!player.level().isClientSide) {
            NetworkHandler.broadcastToAll(new MarkTargetPacket(player.getUUID(), entityId, endTime, false), player.level());
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        Player player;
        Map.Entry<Integer, Long> targetInfo;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (targetInfo = MARKED_TARGETS.get((player = (Player)entity).getUUID())) != null && event.getEntity().getId() == targetInfo.getKey().intValue()) {
            float newDamage = event.getNewDamage() * (float)ModConfig.getTacticalDamageMultiplier();
            event.setNewDamage(newDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        UUID playerUUID;
        Map.Entry<Integer, Long> targetInfo;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (targetInfo = MARKED_TARGETS.get(playerUUID = (player = (Player)entity).getUUID())) != null && event.getEntity().getId() == targetInfo.getKey().intValue()) {
            SHOULD_REMARK.put(playerUUID, true);
            SCAN_COOLDOWNS.remove(playerUUID);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.minds_eye.effects", (Object[])new Object[]{Float.valueOf((float)((Integer)ModConfig.COMMON.TACTICAL_SCAN_INTERVAL.get()).intValue() / 20.0f)}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.minds_eye.effects1", (Object[])new Object[]{((Double)ModConfig.COMMON.TACTICAL_DAMAGE_MULTIPLIER.get() - 1.0) * 100.0}).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.minds_eye.effects2").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

