/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MagicMirrorItem
extends Item {
    private static final int COOLDOWN_TICKS = 10;
    private static final int USE_DURATION = 20;
    private static final float PARTICLE_RADIUS = 1.0f;

    public MagicMirrorItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.spawnActivationParticles(serverPlayer, 0.5f);
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float progress = 1.0f - (float)remainingTicks / 20.0f;
            this.spawnChargeParticles(player, progress);
        }
    }

    private void spawnActivationParticles(ServerPlayer player, float scale) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y, pos.z, 300, (double)(1.0f * scale), 0.2 * (double)scale, (double)(1.0f * scale), 0.1);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.spawnCompletionParticles(player);
            this.teleportToSpawn(player);
            player.getCooldowns().addCooldown((Item)this, 10);
        }
        return stack;
    }

    private void spawnChargeParticles(ServerPlayer player, float progress) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 lookVec = player.getLookAngle().scale(0.5);
        Vec3 pos = player.position().add(0.0, (double)player.getEyeHeight() - 0.2, 0.0).add(lookVec);
        serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.1f, 1.0f), 0.5f), pos.x, pos.y, pos.z, 4, 0.1, 0.1, 0.1, 0.0);
    }

    private void spawnCompletionParticles(ServerPlayer player) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        Vec3 pos = player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pos.x, pos.y, pos.z, 300, 1.0, 1.0, 1.0, 0.3);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y + 1.0, pos.z, 500, 0.8, 0.8, 0.8, 1.0);
    }

    protected void teleportToSpawn(ServerPlayer player) {
        ServerLevel targetLevel = player.server.getLevel(player.getRespawnDimension());
        BlockPos spawnPos = player.getRespawnPosition();
        float spawnAngle = player.getRespawnAngle();
        if (spawnPos == null || targetLevel == null) {
            targetLevel = player.server.overworld();
            spawnPos = targetLevel.getSharedSpawnPos();
        }
        player.teleportTo(targetLevel, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, spawnAngle, 0.0f);
        player.fallDistance = 0.0f;
        this.playTeleportEffects(player);
    }

    private void playTeleportEffects(ServerPlayer player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY() + 1.0, player.getZ(), 500, 0.5, 0.5, 0.5, 1.0);
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.magic_mirror.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.magic_mirror.description").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.magic_mirror.description1").withStyle(ChatFormatting.GREEN));
    }
}

