/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModComponents;
import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class MadAuraItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public MadAuraItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        if (!stack.has(ModComponents.IS_INITIALIZED)) {
            stack.set(ModComponents.IS_INITIALIZED, (Object)true);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.has(ModComponents.MAD_AURA_COOLDOWN)) {
                long cooldownEnd = (Long)stack.get(ModComponents.MAD_AURA_COOLDOWN);
                if (slotContext.entity().level().getGameTime() >= cooldownEnd) {
                    stack.remove(ModComponents.MAD_AURA_COOLDOWN);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.getItem() instanceof MadAuraItem).ifPresent(result -> {
            ItemStack stack = result.stack();
            if (!stack.has(ModComponents.MAD_AURA_COOLDOWN)) {
                event.setNewDamage(0.0f);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 0.5f, 1.5f);
                stack.set(ModComponents.MAD_AURA_COOLDOWN, (Object)(player.level().getGameTime() + (long)ModConfig.getMadAuraCooldown()));
            }
        }));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.madaura.effects", (Object[])new Object[]{Float.valueOf((float)ModConfig.getMadAuraCooldown() / 20.0f)}).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

