/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class LuckyHorseshoeItem
extends ModifiableBaubleItem {
    private static final float FALL_DAMAGE_REDUCTION = 0.0f;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public LuckyHorseshoeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @SubscribeEvent
    public static void onFallDamage(LivingFallEvent event) {
        if (LuckyHorseshoeItem.isEquipped(event.getEntity())) {
            event.setDamageMultiplier(0.0f);
            event.setDistance(0.0f);
        }
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof LuckyHorseshoeItem)).isPresent();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.lucky_horseshoe.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.lucky_horseshoe.description").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

