/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class LuckCoinItem
extends ModifiableBaubleItem {
    private static final Random RANDOM = new Random();

    public LuckCoinItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return ModifiableBaubleItem.Modifier.values();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean hasLuckCoin = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof LuckCoinItem)).isPresent();
        if (!hasLuckCoin) {
            return;
        }
        List<Double> bonuses = ModConfig.getLuckCoinDamageBonuses();
        List<Double> probabilities = ModConfig.getLuckCoinProbabilities();
        if (bonuses.size() != probabilities.size()) {
            return;
        }
        double roll = RANDOM.nextDouble();
        double cumulativeProbability = 0.0;
        for (int i = 0; i < probabilities.size(); ++i) {
            if (!(roll < (cumulativeProbability += probabilities.get(i).doubleValue()))) continue;
            float bonus = (float)(1.0 + bonuses.get(i));
            event.setNewDamage(event.getNewDamage() * bonus);
            break;
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        List<Double> bonuses = ModConfig.getLuckCoinDamageBonuses();
        List<Double> probabilities = ModConfig.getLuckCoinProbabilities();
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.luckcoin.title").withStyle(ChatFormatting.BLUE));
        for (int i = 0; i < bonuses.size() && i < probabilities.size(); ++i) {
            tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.luckcoin.bonus_line", (Object[])new Object[]{probabilities.get(i) * 100.0, bonuses.get(i) * 100.0}).withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

