/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.ModConfig;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import com.jinqinxixi.bountifulbaubles.network.CoolDownSyncPacket;
import com.jinqinxixi.bountifulbaubles.network.TotemNetworkHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class InfiniteTotemOfUndyingItem
extends ModifiableBaubleItem {
    public static final String PUBLIC_COOLDOWN_TAG = "bountifulbaubles:totem_cooldown";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public InfiniteTotemOfUndyingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    private static int getCooldownTicks() {
        return CoolDownSyncPacket.ClientConfigCache.getTotemCooldown();
    }

    @SubscribeEvent
    public static void onCriticalDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (player.level().isClientSide) {
            return;
        }
        float damageAmount = event.getContainer().getNewDamage();
        if (InfiniteTotemOfUndyingItem.isEquipped((LivingEntity)player) && player.getHealth() <= damageAmount && InfiniteTotemOfUndyingItem.tryActivateTotem(player)) {
            event.getContainer().setNewDamage(0.0f);
        }
    }

    private static boolean tryActivateTotem(ServerPlayer player) {
        ItemStack offhandItem = player.getOffhandItem();
        if (offhandItem.getItem() instanceof InfiniteTotemOfUndyingItem) {
            return InfiniteTotemOfUndyingItem.activateTotem(player);
        }
        ItemStack mainhandItem = player.getMainHandItem();
        if (mainhandItem.getItem() instanceof InfiniteTotemOfUndyingItem) {
            return InfiniteTotemOfUndyingItem.activateTotem(player);
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof InfiniteTotemOfUndyingItem)).map(curio -> InfiniteTotemOfUndyingItem.activateTotem(player)).orElse(false);
    }

    private static boolean activateTotem(ServerPlayer player) {
        CompoundTag data = player.getPersistentData();
        int remaining = data.getInt(PUBLIC_COOLDOWN_TAG);
        if (remaining <= 0) {
            int cooldown = ModConfig.getTotemCooldown();
            data.putInt(PUBLIC_COOLDOWN_TAG, cooldown);
            InfiniteTotemOfUndyingItem.syncCoolDownToClient(player, cooldown, ModConfig.getTotemCooldown());
            InfiniteTotemOfUndyingItem.activateTotemEffects(player);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer serverPlayer;
        CompoundTag data;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (data = (serverPlayer = (ServerPlayer)player).getPersistentData()).contains(PUBLIC_COOLDOWN_TAG)) {
            int configDuration;
            int current = data.getInt(PUBLIC_COOLDOWN_TAG);
            if (current > (configDuration = ModConfig.getTotemCooldown())) {
                current = configDuration;
                data.putInt(PUBLIC_COOLDOWN_TAG, current);
            }
            if (current > 0) {
                int updated = current - 1;
                data.putInt(PUBLIC_COOLDOWN_TAG, updated);
                InfiniteTotemOfUndyingItem.syncCoolDownToClient(serverPlayer, updated, configDuration);
            } else {
                data.remove(PUBLIC_COOLDOWN_TAG);
                InfiniteTotemOfUndyingItem.syncCoolDownToClient(serverPlayer, -1, configDuration);
            }
        }
    }

    private static void syncCoolDownToClient(ServerPlayer player, int remaining, int configValue) {
        TotemNetworkHandler.sendToPlayer(player, new CoolDownSyncPacket(remaining, configValue));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player;
        if (event.isWasDeath() && (player = event.getOriginal()) instanceof ServerPlayer) {
            ServerPlayer original = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                CompoundTag originalData = original.getPersistentData();
                CompoundTag newData = newPlayer.getPersistentData();
                int configDuration = ModConfig.getTotemCooldown();
                if (originalData.contains(PUBLIC_COOLDOWN_TAG)) {
                    int remaining = originalData.getInt(PUBLIC_COOLDOWN_TAG);
                    remaining = Math.min(remaining, configDuration);
                    newData.putInt(PUBLIC_COOLDOWN_TAG, remaining);
                    InfiniteTotemOfUndyingItem.syncCoolDownToClient(newPlayer, remaining, configDuration);
                }
            }
        }
    }

    private static void activateTotemEffects(ServerPlayer player) {
        player.setHealth(1.0f);
        player.removeAllEffects();
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        ServerLevel level = (ServerLevel)player.level();
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        int PARTICLE_COUNT = 250;
        double BASE_SPEED = 1.8;
        double SPEED_VARIATION = 0.6;
        double VERTICAL_BIAS = 0.2;
        double SPREAD_RADIUS = 0.5;
        for (int i = 0; i < 250; ++i) {
            double theta = level.random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(1.0 - 2.0 * level.random.nextDouble());
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.sin(phi) * Math.sin(theta) * 0.8;
            double dirZ = Math.cos(phi);
            double speed = (1.8 + level.random.nextDouble() * 0.6) * (1.0 + level.random.nextDouble());
            double offset = 0.5 * level.random.nextDouble();
            double posX = x + dirX * offset;
            double posY = y + 1.0 + dirY * offset;
            double posZ = z + dirZ * offset;
            level.sendParticles(player, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, true, posX, posY, posZ, 1, dirX * speed, dirY * speed, dirZ * speed, 0.1);
        }
        int SHOCKWAVE_COUNT = 120;
        double SHOCKWAVE_SPEED = 3.2;
        double SOUL_FIRE_RATIO = 0.6;
        for (int i = 0; i < 120; ++i) {
            SimpleParticleType particleType;
            double angle = level.random.nextDouble() * 2.0 * Math.PI;
            double speed = 3.2 * (0.8 + level.random.nextDouble() * 0.4);
            double vy = level.random.nextDouble() * 0.8 - 0.4;
            SimpleParticleType simpleParticleType = particleType = level.random.nextDouble() < 0.6 ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
            if (particleType == ParticleTypes.SOUL_FIRE_FLAME) {
                speed *= 1.1;
                vy += 0.15;
            }
            level.sendParticles(player, (ParticleOptions)particleType, true, x, y + 1.2, z, 1, Math.cos(angle) * speed, vy, Math.sin(angle) * speed, particleType == ParticleTypes.SOUL_FIRE_FLAME ? 0.12 : 0.15);
            if (!(level.random.nextDouble() < 0.3)) continue;
            level.sendParticles(player, (ParticleOptions)ParticleTypes.SMOKE, true, x, y + 1.0, z, 1, Math.cos(angle) * speed * 0.7, vy * 0.5, Math.sin(angle) * speed * 0.7, 0.08);
        }
        level.playSound(null, x, y, z, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBarVisible(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        CompoundTag data = player.getPersistentData();
        return data.contains(PUBLIC_COOLDOWN_TAG) && data.getInt(PUBLIC_COOLDOWN_TAG) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBarWidth(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && this.isBarVisible(stack)) {
            int remaining = player.getPersistentData().getInt(PUBLIC_COOLDOWN_TAG);
            int total = CoolDownSyncPacket.ClientConfigCache.getTotemCooldown();
            return Math.round(13.0f * (1.0f - (float)remaining / (float)total));
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBarColor(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getPersistentData().contains(PUBLIC_COOLDOWN_TAG)) {
            int remaining = player.getPersistentData().getInt(PUBLIC_COOLDOWN_TAG);
            int total = InfiniteTotemOfUndyingItem.getCooldownTicks();
            float progress = (float)(total - remaining) / (float)total;
            return Mth.hsvToRgb((float)(progress * 0.33f), (float)1.0f, (float)1.0f);
        }
        return super.getBarColor(stack);
    }

    private static boolean isEquipped(LivingEntity entity) {
        Optional<Boolean> curiosCheck = CuriosApi.getCuriosInventory((LivingEntity)entity).map(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof InfiniteTotemOfUndyingItem).isPresent());
        boolean mainHand = entity.getMainHandItem().getItem() instanceof InfiniteTotemOfUndyingItem;
        boolean offHand = entity.getOffhandItem().getItem() instanceof InfiniteTotemOfUndyingItem;
        return curiosCheck.orElse(false) != false || mainHand || offHand;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.infinite_totem_undying.effect").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.infinite_totem_undying.description").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

