/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class IceShardItem
extends ModifiableBaubleItem {
    private static final int FROST_RANGE = 2;

    public IceShardItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return ModifiableBaubleItem.Modifier.values();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        boolean hasIceShard = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof IceShardItem)).isPresent();
        if (!hasIceShard) {
            return;
        }
        if (IceShardItem.isAboveWater(player) && !player.isInWater()) {
            IceShardItem.createFrostPath(player);
        }
    }

    private static boolean canFreezeWater(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.WATER)) {
            return false;
        }
        if (!state.getFluidState().isSource()) {
            return false;
        }
        return level.getBlockState(pos.above()).isAir();
    }

    private static boolean isAboveWater(Player player) {
        BlockPos pos = player.blockPosition().below();
        return IceShardItem.canFreezeWater(player.level(), pos);
    }

    private static void createFrostPath(Player player) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos playerPos = player.blockPosition();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos = playerPos.offset(x, -1, z);
                if (!IceShardItem.canFreezeWater((Level)serverLevel, pos)) continue;
                serverLevel.setBlockAndUpdate(pos, Blocks.FROSTED_ICE.defaultBlockState());
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.ice_shard.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

