/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.mobeffects.ModEffects;
import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="bountifulbaubles")
public class GluttonyPendantItem
extends ModifiableBaubleItem {
    private static final float EATING_SPEED_MULTIPLIER = 0.5f;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public GluttonyPendantItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @SubscribeEvent
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (GluttonyPendantItem.isEquipped(event.getEntity()) && GluttonyPendantItem.isEdible(event.getItem())) {
            int newDuration = (int)((float)event.getDuration() * 0.5f);
            event.setDuration(Math.max(newDuration, 1));
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && GluttonyPendantItem.isEquipped((LivingEntity)(player = (Player)livingEntity))) {
            GluttonyPendantItem.applySinfulEffect(player, event.getItem());
        }
    }

    private static void applySinfulEffect(Player player, ItemStack foodStack) {
        float saturationModifier;
        int hunger;
        int level;
        FoodProperties food = foodStack.getFoodProperties((LivingEntity)player);
        if (food != null && (level = GluttonyPendantItem.calculateSinLevel(hunger = food.nutrition(), saturationModifier = food.saturation() / ((float)hunger * 2.0f)) - 2) >= 0) {
            player.addEffect(new MobEffectInstance(ModEffects.SINFUL, 200, level, false, true, true));
        }
    }

    private static boolean isEdible(ItemStack stack) {
        return stack.getComponents().has(DataComponents.FOOD);
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return (FoodProperties)stack.get(DataComponents.FOOD);
    }

    public static int calculateSinLevel(int hunger, float saturation) {
        return (int)Math.floor((double)hunger / 4.0 + (double)saturation / 6.0 + 1.0);
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.findFirstCurio(stack -> stack.getItem() instanceof GluttonyPendantItem)).isPresent();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.gluttony_pendant.effect").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

