/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.items.Baubles;

import com.jinqinxixi.bountifulbaubles.modifier.ModifiableBaubleItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class FireMindItem
extends ModifiableBaubleItem {
    private static final double RANGE = 10.0;
    private static final int FIRE_DURATION = 60;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public FireMindItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyModifier(player, stack);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.removeModifier(player, stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickPre(PlayerTickEvent.Pre event) {
        boolean hasFireMind;
        Player player = event.getEntity();
        if (!player.level().isClientSide() && (hasFireMind = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio(item -> item.getItem() instanceof FireMindItem)).isPresent())) {
            Vec3 lookVec = player.getLookAngle();
            Vec3 eyePos = player.getEyePosition();
            AABB searchBox = player.getBoundingBox().inflate(10.0);
            List entities = player.level().getEntities((Entity)player, searchBox);
            for (Entity target : entities) {
                BlockHitResult result;
                double dot;
                Vec3 toTarget;
                double distance;
                if (!(target instanceof LivingEntity) || target == player || target.getRemainingFireTicks() > 0 || !((distance = (toTarget = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0).subtract(eyePos)).length()) <= 10.0) || !((dot = toTarget.normalize().dot(lookVec)) > 0.98) || (result = player.level().clip(new ClipContext(eyePos, target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).getType() != HitResult.Type.MISS && !(result.getLocation().distanceToSqr(eyePos) > distance * distance)) continue;
                target.setRemainingFireTicks(60);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulbaubles.fire_mind.effects").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

